/*
 * Decompiled with CFR 0.152.
 */
package com.androidadvance.topsnackbar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.core.view.ViewPropertyAnimatorListenerAdapter;
import com.androidadvance.topsnackbar.AnimationUtils;
import com.androidadvance.topsnackbar.R;
import com.androidadvance.topsnackbar.SnackbarManager;
import com.google.android.material.behavior.SwipeDismissBehavior;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class TSnackbar {
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;
    private static final int ANIMATION_DURATION = 250;
    private static final int ANIMATION_FADE_DURATION = 180;
    private static final Handler sHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    ((TSnackbar)message.obj).showView();
                    return true;
                }
                case 1: {
                    ((TSnackbar)message.obj).hideView(message.arg1);
                    return true;
                }
            }
            return false;
        }
    });
    private static final int MSG_SHOW = 0;
    private static final int MSG_DISMISS = 1;
    private final ViewGroup mParent;
    private final Context mContext;
    private final SnackbarLayout mView;
    private int mDuration;
    private Callback mCallback;
    private final SnackbarManager.Callback mManagerCallback = new SnackbarManager.Callback(){

        @Override
        public void show() {
            sHandler.sendMessage(sHandler.obtainMessage(0, (Object)TSnackbar.this));
        }

        @Override
        public void dismiss(int event) {
            sHandler.sendMessage(sHandler.obtainMessage(1, event, 0, (Object)TSnackbar.this));
        }
    };

    private TSnackbar(ViewGroup parent) {
        this.mParent = parent;
        this.mContext = parent.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        this.mView = (SnackbarLayout)inflater.inflate(R.layout.tsnackbar_layout, this.mParent, false);
    }

    @NonNull
    public static TSnackbar make(@NonNull View view, @NonNull CharSequence text, int duration) {
        TSnackbar snackbar = new TSnackbar(TSnackbar.findSuitableParent(view));
        snackbar.setText(text);
        snackbar.setDuration(duration);
        return snackbar;
    }

    @NonNull
    public static TSnackbar make(@NonNull View view, @StringRes int resId, int duration) {
        return TSnackbar.make(view, view.getResources().getText(resId), duration);
    }

    private static ViewGroup findSuitableParent(View view) {
        ViewGroup fallback = null;
        do {
            ViewParent parent;
            if (view instanceof CoordinatorLayout) {
                return (ViewGroup)view;
            }
            if (view instanceof FrameLayout) {
                if (view.getId() == 0x1020002) {
                    return (ViewGroup)view;
                }
                fallback = (ViewGroup)view;
            } else if ((view instanceof Toolbar || Build.VERSION.SDK_INT >= 21 && view instanceof android.widget.Toolbar) && view.getParent() instanceof ViewGroup && (parent = (ViewGroup)view.getParent()).getChildCount() > 1) {
                int childrenCnt = parent.getChildCount();
                for (int i = 0; i < childrenCnt; ++i) {
                    if (parent.getChildAt(i) != view) continue;
                    int toolbarIdx = i;
                    if (toolbarIdx >= childrenCnt - 1) break;
                    while (i < childrenCnt) {
                        View v;
                        if (!((v = parent.getChildAt(++i)) instanceof ViewGroup)) continue;
                        return (ViewGroup)v;
                    }
                    break;
                }
            }
            if (view == null) continue;
            parent = view.getParent();
            View view2 = view = parent instanceof View ? (View)parent : null;
        } while (view != null);
        return fallback;
    }

    @Deprecated
    public TSnackbar addIcon(int resource_id, int size) {
        TextView tv = this.mView.getMessageView();
        tv.setCompoundDrawablesWithIntrinsicBounds((Drawable)new BitmapDrawable(this.mContext.getResources(), Bitmap.createScaledBitmap((Bitmap)((BitmapDrawable)ResourcesCompat.getDrawable((Resources)this.mContext.getResources(), (int)resource_id, null)).getBitmap(), (int)size, (int)size, (boolean)true)), null, null, null);
        return this;
    }

    public TSnackbar setIconPadding(int padding) {
        TextView tv = this.mView.getMessageView();
        tv.setCompoundDrawablePadding(padding);
        return this;
    }

    public TSnackbar setIconLeft(@DrawableRes int drawableRes, float sizeDp) {
        TextView tv = this.mView.getMessageView();
        Drawable drawable = ContextCompat.getDrawable((Context)this.mContext, (int)drawableRes);
        if (drawable == null) {
            throw new IllegalArgumentException("resource_id is not a valid drawable!");
        }
        drawable = this.fitDrawable(drawable, (int)TSnackbar.convertDpToPixel(sizeDp, this.mContext));
        Drawable[] compoundDrawables = tv.getCompoundDrawables();
        tv.setCompoundDrawables(drawable, compoundDrawables[1], compoundDrawables[2], compoundDrawables[3]);
        return this;
    }

    public TSnackbar setIconRight(@DrawableRes int drawableRes, float sizeDp) {
        TextView tv = this.mView.getMessageView();
        Drawable drawable = ContextCompat.getDrawable((Context)this.mContext, (int)drawableRes);
        if (drawable == null) {
            throw new IllegalArgumentException("resource_id is not a valid drawable!");
        }
        drawable = this.fitDrawable(drawable, (int)TSnackbar.convertDpToPixel(sizeDp, this.mContext));
        Drawable[] compoundDrawables = tv.getCompoundDrawables();
        tv.setCompoundDrawables(compoundDrawables[0], compoundDrawables[1], drawable, compoundDrawables[3]);
        return this;
    }

    public TSnackbar setMaxWidth(int maxWidth) {
        this.mView.mMaxWidth = maxWidth;
        return this;
    }

    private Drawable fitDrawable(Drawable drawable, int sizePx) {
        if ((drawable.getIntrinsicWidth() != sizePx || drawable.getIntrinsicHeight() != sizePx) && drawable instanceof BitmapDrawable) {
            drawable = new BitmapDrawable(this.mContext.getResources(), Bitmap.createScaledBitmap((Bitmap)TSnackbar.getBitmap(drawable), (int)sizePx, (int)sizePx, (boolean)true));
        }
        drawable.setBounds(0, 0, sizePx, sizePx);
        return drawable;
    }

    private static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    @TargetApi(value=21)
    private static Bitmap getBitmap(VectorDrawable vectorDrawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return bitmap;
    }

    private static Bitmap getBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        if (Build.VERSION.SDK_INT >= 21 && drawable instanceof VectorDrawable) {
            return TSnackbar.getBitmap((VectorDrawable)drawable);
        }
        throw new IllegalArgumentException("unsupported drawable type");
    }

    @NonNull
    public TSnackbar setAction(@StringRes int resId, View.OnClickListener listener) {
        return this.setAction(this.mContext.getText(resId), listener);
    }

    @NonNull
    public TSnackbar setAction(CharSequence text, View.OnClickListener listener) {
        return this.setAction(text, true, listener);
    }

    @NonNull
    public TSnackbar setAction(CharSequence text, final boolean shouldDismissOnClick, final View.OnClickListener listener) {
        Button tv = this.mView.getActionView();
        if (TextUtils.isEmpty((CharSequence)text) || listener == null) {
            tv.setVisibility(8);
            tv.setOnClickListener(null);
        } else {
            tv.setVisibility(0);
            tv.setText(text);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    listener.onClick(view);
                    if (shouldDismissOnClick) {
                        TSnackbar.this.dispatchDismiss(1);
                    }
                }
            });
        }
        return this;
    }

    @NonNull
    public TSnackbar setActionTextColor(ColorStateList colors) {
        Button tv = this.mView.getActionView();
        tv.setTextColor(colors);
        return this;
    }

    @NonNull
    public TSnackbar setActionTextColor(@ColorInt int color) {
        Button tv = this.mView.getActionView();
        tv.setTextColor(color);
        return this;
    }

    @NonNull
    public TSnackbar setText(@NonNull CharSequence message) {
        TextView tv = this.mView.getMessageView();
        tv.setText(message);
        return this;
    }

    @NonNull
    public TSnackbar setText(@StringRes int resId) {
        return this.setText(this.mContext.getText(resId));
    }

    @NonNull
    public TSnackbar setDuration(int duration) {
        this.mDuration = duration;
        return this;
    }

    public int getDuration() {
        return this.mDuration;
    }

    @NonNull
    public View getView() {
        return this.mView;
    }

    public void show() {
        SnackbarManager.getInstance().show(this.mDuration, this.mManagerCallback);
    }

    public void dismiss() {
        this.dispatchDismiss(3);
    }

    private void dispatchDismiss(int event) {
        SnackbarManager.getInstance().dismiss(this.mManagerCallback, event);
    }

    @NonNull
    public TSnackbar setCallback(Callback callback) {
        this.mCallback = callback;
        return this;
    }

    public boolean isShown() {
        return SnackbarManager.getInstance().isCurrent(this.mManagerCallback);
    }

    public boolean isShownOrQueued() {
        return SnackbarManager.getInstance().isCurrentOrNext(this.mManagerCallback);
    }

    final void showView() {
        if (this.mView.getParent() == null) {
            ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
            if (lp instanceof CoordinatorLayout.LayoutParams) {
                Behavior behavior = new Behavior();
                behavior.setStartAlphaSwipeDistance(0.1f);
                behavior.setEndAlphaSwipeDistance(0.6f);
                behavior.setSwipeDirection(0);
                behavior.setListener(new SwipeDismissBehavior.OnDismissListener(){

                    public void onDismiss(View view) {
                        TSnackbar.this.dispatchDismiss(0);
                    }

                    public void onDragStateChanged(int state) {
                        switch (state) {
                            case 1: 
                            case 2: {
                                SnackbarManager.getInstance().cancelTimeout(TSnackbar.this.mManagerCallback);
                                break;
                            }
                            case 0: {
                                SnackbarManager.getInstance().restoreTimeout(TSnackbar.this.mManagerCallback);
                            }
                        }
                    }
                });
                ((CoordinatorLayout.LayoutParams)lp).setBehavior((CoordinatorLayout.Behavior)behavior);
            }
            this.mParent.addView((View)this.mView);
        }
        this.mView.setOnAttachStateChangeListener(new SnackbarLayout.OnAttachStateChangeListener(){

            @Override
            public void onViewAttachedToWindow(View v) {
            }

            @Override
            public void onViewDetachedFromWindow(View v) {
                if (TSnackbar.this.isShownOrQueued()) {
                    sHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            TSnackbar.this.onViewHidden(3);
                        }
                    });
                }
            }
        });
        if (ViewCompat.isLaidOut((View)this.mView)) {
            this.animateViewIn();
        } else {
            this.mView.setOnLayoutChangeListener(new SnackbarLayout.OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(View view, int left, int top, int right, int bottom) {
                    TSnackbar.this.animateViewIn();
                    TSnackbar.this.mView.setOnLayoutChangeListener(null);
                }
            });
        }
    }

    private void animateViewIn() {
        this.mView.setTranslationY(-this.mView.getHeight());
        ViewCompat.animate((View)this.mView).translationY(0.0f).setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR).setDuration(250L).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                TSnackbar.this.mView.animateChildrenIn(70, 180);
            }

            public void onAnimationEnd(View view) {
                if (TSnackbar.this.mCallback != null) {
                    TSnackbar.this.mCallback.onShown(TSnackbar.this);
                }
                SnackbarManager.getInstance().onShown(TSnackbar.this.mManagerCallback);
            }
        }).start();
    }

    private void animateViewOut(final int event) {
        ViewCompat.animate((View)this.mView).translationY((float)(-this.mView.getHeight())).setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR).setDuration(250L).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                TSnackbar.this.mView.animateChildrenOut(0, 180);
            }

            public void onAnimationEnd(View view) {
                TSnackbar.this.onViewHidden(event);
            }
        }).start();
    }

    final void hideView(int event) {
        if (this.mView.getVisibility() != 0 || this.isBeingDragged()) {
            this.onViewHidden(event);
        } else {
            this.animateViewOut(event);
        }
    }

    private void onViewHidden(int event) {
        ViewParent parent;
        SnackbarManager.getInstance().onDismissed(this.mManagerCallback);
        if (this.mCallback != null) {
            this.mCallback.onDismissed(this, event);
        }
        if ((parent = this.mView.getParent()) instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this.mView);
        }
    }

    private boolean isBeingDragged() {
        CoordinatorLayout.LayoutParams cllp;
        CoordinatorLayout.Behavior behavior;
        ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
        if (lp instanceof CoordinatorLayout.LayoutParams && (behavior = (cllp = (CoordinatorLayout.LayoutParams)lp).getBehavior()) instanceof SwipeDismissBehavior) {
            return ((SwipeDismissBehavior)behavior).getDragState() != 0;
        }
        return false;
    }

    final class Behavior
    extends SwipeDismissBehavior<SnackbarLayout> {
        Behavior() {
        }

        public boolean canSwipeDismissView(@NonNull View child) {
            return child instanceof SnackbarLayout;
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout parent, @NonNull SnackbarLayout child, MotionEvent event) {
            if (parent.isPointInChildBounds((View)child, (int)event.getX(), (int)event.getY())) {
                switch (event.getActionMasked()) {
                    case 0: {
                        SnackbarManager.getInstance().cancelTimeout(TSnackbar.this.mManagerCallback);
                        break;
                    }
                    case 1: 
                    case 3: {
                        SnackbarManager.getInstance().restoreTimeout(TSnackbar.this.mManagerCallback);
                    }
                }
            }
            return super.onInterceptTouchEvent(parent, (View)child, event);
        }
    }

    public static class SnackbarLayout
    extends LinearLayout {
        private TextView mMessageView;
        private Button mActionView;
        private int mMaxWidth;
        private final int mMaxInlineActionWidth;
        private OnLayoutChangeListener mOnLayoutChangeListener;
        private OnAttachStateChangeListener mOnAttachStateChangeListener;

        public SnackbarLayout(Context context) {
            this(context, null);
        }

        public SnackbarLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SnackbarLayout);
            this.mMaxWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_android_maxWidth, -1);
            this.mMaxInlineActionWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_maxActionInlineWidth, -1);
            if (a.hasValue(R.styleable.SnackbarLayout_elevation)) {
                ViewCompat.setElevation((View)this, (float)a.getDimensionPixelSize(R.styleable.SnackbarLayout_elevation, 0));
            }
            a.recycle();
            this.setClickable(true);
            LayoutInflater.from((Context)context).inflate(R.layout.tsnackbar_layout_include, (ViewGroup)this);
            ViewCompat.setAccessibilityLiveRegion((View)this, (int)1);
        }

        protected void onFinishInflate() {
            super.onFinishInflate();
            this.mMessageView = (TextView)this.findViewById(R.id.snackbar_text);
            this.mActionView = (Button)this.findViewById(R.id.snackbar_action);
        }

        TextView getMessageView() {
            return this.mMessageView;
        }

        Button getActionView() {
            return this.mActionView;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.mMaxWidth > 0 && this.getMeasuredWidth() > this.mMaxWidth) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)0x40000000);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
            int multiLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical_2lines);
            int singleLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical);
            boolean isMultiLine = this.mMessageView.getLayout().getLineCount() > 1;
            boolean remeasure = false;
            if (isMultiLine && this.mMaxInlineActionWidth > 0 && this.mActionView.getMeasuredWidth() > this.mMaxInlineActionWidth) {
                if (this.updateViewsWithinLayout(1, multiLineVPadding, multiLineVPadding - singleLineVPadding)) {
                    remeasure = true;
                }
            } else {
                int messagePadding;
                int n = messagePadding = isMultiLine ? multiLineVPadding : singleLineVPadding;
                if (this.updateViewsWithinLayout(0, messagePadding, messagePadding)) {
                    remeasure = true;
                }
            }
            if (remeasure) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }

        void animateChildrenIn(int delay, int duration) {
            this.mMessageView.setAlpha(0.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            if (this.mActionView.getVisibility() == 0) {
                this.mActionView.setAlpha(0.0f);
                ViewCompat.animate((View)this.mActionView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            }
        }

        void animateChildrenOut(int delay, int duration) {
            this.mMessageView.setAlpha(1.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            if (this.mActionView.getVisibility() == 0) {
                this.mActionView.setAlpha(1.0f);
                ViewCompat.animate((View)this.mActionView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (this.mOnLayoutChangeListener != null) {
                this.mOnLayoutChangeListener.onLayoutChange((View)this, l, t, r, b);
            }
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            if (this.mOnAttachStateChangeListener != null) {
                this.mOnAttachStateChangeListener.onViewAttachedToWindow((View)this);
            }
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.mOnAttachStateChangeListener != null) {
                this.mOnAttachStateChangeListener.onViewDetachedFromWindow((View)this);
            }
        }

        void setOnLayoutChangeListener(OnLayoutChangeListener onLayoutChangeListener) {
            this.mOnLayoutChangeListener = onLayoutChangeListener;
        }

        void setOnAttachStateChangeListener(OnAttachStateChangeListener listener) {
            this.mOnAttachStateChangeListener = listener;
        }

        private boolean updateViewsWithinLayout(int orientation, int messagePadTop, int messagePadBottom) {
            boolean changed = false;
            if (orientation != this.getOrientation()) {
                this.setOrientation(orientation);
                changed = true;
            }
            if (this.mMessageView.getPaddingTop() != messagePadTop || this.mMessageView.getPaddingBottom() != messagePadBottom) {
                SnackbarLayout.updateTopBottomPadding((View)this.mMessageView, messagePadTop, messagePadBottom);
                changed = true;
            }
            return changed;
        }

        private static void updateTopBottomPadding(View view, int topPadding, int bottomPadding) {
            if (ViewCompat.isPaddingRelative((View)view)) {
                ViewCompat.setPaddingRelative((View)view, (int)ViewCompat.getPaddingStart((View)view), (int)topPadding, (int)ViewCompat.getPaddingEnd((View)view), (int)bottomPadding);
            } else {
                view.setPadding(view.getPaddingLeft(), topPadding, view.getPaddingRight(), bottomPadding);
            }
        }

        static interface OnAttachStateChangeListener {
            public void onViewAttachedToWindow(View var1);

            public void onViewDetachedFromWindow(View var1);
        }

        static interface OnLayoutChangeListener {
            public void onLayoutChange(View var1, int var2, int var3, int var4, int var5);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }

    public static abstract class Callback {
        public static final int DISMISS_EVENT_SWIPE = 0;
        public static final int DISMISS_EVENT_ACTION = 1;
        public static final int DISMISS_EVENT_TIMEOUT = 2;
        public static final int DISMISS_EVENT_MANUAL = 3;
        public static final int DISMISS_EVENT_CONSECUTIVE = 4;

        public void onDismissed(TSnackbar snackbar, int event) {
        }

        public void onShown(TSnackbar snackbar) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DismissEvent {
        }
    }
}

