/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.Mask;
import com.redmadrobot.inputmask.model.CaretString;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002j\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/redmadrobot/inputmask/helper/AffinityCalculationStrategy;", "", "(Ljava/lang/String;I)V", "calculateAffinityOfMask", "", "mask", "Lcom/redmadrobot/inputmask/helper/Mask;", "text", "Lcom/redmadrobot/inputmask/model/CaretString;", "prefixIntersection", "", "another", "WHOLE_STRING", "PREFIX", "CAPACITY", "EXTRACTED_VALUE_CAPACITY", "inputmask_release"})
public final class AffinityCalculationStrategy
extends Enum<AffinityCalculationStrategy> {
    public static final /* enum */ AffinityCalculationStrategy WHOLE_STRING = new AffinityCalculationStrategy();
    public static final /* enum */ AffinityCalculationStrategy PREFIX = new AffinityCalculationStrategy();
    public static final /* enum */ AffinityCalculationStrategy CAPACITY = new AffinityCalculationStrategy();
    public static final /* enum */ AffinityCalculationStrategy EXTRACTED_VALUE_CAPACITY = new AffinityCalculationStrategy();
    private static final /* synthetic */ AffinityCalculationStrategy[] $VALUES;

    public final int calculateAffinityOfMask(@NotNull Mask mask, @NotNull CaretString text) {
        int n;
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                n = mask.apply(text).getAffinity();
                break;
            }
            case 2: {
                n = this.prefixIntersection(mask.apply(text).getFormattedText().getString(), text.getString()).length();
                break;
            }
            case 3: {
                if (text.getString().length() > mask.totalTextLength()) {
                    n = Integer.MIN_VALUE;
                    break;
                }
                n = text.getString().length() - mask.totalTextLength();
                break;
            }
            case 4: {
                int extractedValueLength = mask.apply(text).getExtractedValue().length();
                if (extractedValueLength > mask.totalValueLength()) {
                    n = Integer.MIN_VALUE;
                    break;
                }
                n = extractedValueLength - mask.totalValueLength();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final String prefixIntersection(String $this$prefixIntersection, String another) {
        int endIndex;
        if (((CharSequence)$this$prefixIntersection).length() == 0 || ((CharSequence)another).length() == 0) {
            return "";
        }
        for (endIndex = 0; endIndex < $this$prefixIntersection.length() && endIndex < another.length(); ++endIndex) {
            if ($this$prefixIntersection.charAt(endIndex) == another.charAt(endIndex)) {
                continue;
            }
            String string = $this$prefixIntersection.substring(0, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        String string = $this$prefixIntersection.substring(0, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public static AffinityCalculationStrategy[] values() {
        return (AffinityCalculationStrategy[])$VALUES.clone();
    }

    public static AffinityCalculationStrategy valueOf(String value) {
        return Enum.valueOf(AffinityCalculationStrategy.class, value);
    }

    static {
        $VALUES = affinityCalculationStrategyArray = new AffinityCalculationStrategy[]{AffinityCalculationStrategy.WHOLE_STRING, AffinityCalculationStrategy.PREFIX, AffinityCalculationStrategy.CAPACITY, AffinityCalculationStrategy.EXTRACTED_VALUE_CAPACITY};
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AffinityCalculationStrategy.values().length];
            try {
                nArray[AffinityCalculationStrategy.WHOLE_STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AffinityCalculationStrategy.PREFIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AffinityCalculationStrategy.CAPACITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AffinityCalculationStrategy.EXTRACTED_VALUE_CAPACITY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

