/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.FormatSanitizer;
import com.redmadrobot.inputmask.model.Notation;
import com.redmadrobot.inputmask.model.State;
import com.redmadrobot.inputmask.model.state.EOLState;
import com.redmadrobot.inputmask.model.state.FixedState;
import com.redmadrobot.inputmask.model.state.FreeState;
import com.redmadrobot.inputmask.model.state.OptionalValueState;
import com.redmadrobot.inputmask.model.state.ValueState;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ/\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0017\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/redmadrobot/inputmask/helper/Compiler;", "", "customNotations", "", "Lcom/redmadrobot/inputmask/model/Notation;", "(Ljava/util/List;)V", "compile", "Lcom/redmadrobot/inputmask/model/State;", "formatString", "", "valuable", "", "fixed", "lastCharacter", "", "(Ljava/lang/String;ZZLjava/lang/Character;)Lcom/redmadrobot/inputmask/model/State;", "compileWithCustomNotations", "char", "string", "determineInheritedType", "Lcom/redmadrobot/inputmask/model/state/ValueState$StateType;", "(Ljava/lang/Character;)Lcom/redmadrobot/inputmask/model/state/ValueState$StateType;", "determineTypeWithCustomNotations", "FormatError", "input-mask-android_release"})
public final class Compiler {
    @NotNull
    private final List<Notation> customNotations;

    public Compiler(@NotNull List<Notation> customNotations) {
        Intrinsics.checkNotNullParameter(customNotations, (String)"customNotations");
        this.customNotations = customNotations;
    }

    @NotNull
    public final State compile(@NotNull String formatString) throws FormatError {
        Intrinsics.checkNotNullParameter((Object)formatString, (String)"formatString");
        String sanitizedString = new FormatSanitizer().sanitize(formatString);
        return this.compile(sanitizedString, false, false, null);
    }

    private final State compile(String formatString, boolean valuable, boolean fixed, Character lastCharacter) {
        CharSequence charSequence = formatString;
        char c = '\u0000';
        if (charSequence.length() == 0) {
            return new EOLState();
        }
        char c2 = StringsKt.first((CharSequence)formatString);
        c = c2;
        if (c == '[') {
            Character c3 = lastCharacter;
            if (c3 == null || '\\' != c3.charValue()) {
                return this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c2));
            }
        } else if (c == '{') {
            Character c4 = lastCharacter;
            if (c4 == null || '\\' != c4.charValue()) {
                return this.compile(StringsKt.drop((String)formatString, (int)1), false, true, Character.valueOf(c2));
            }
        } else if (c == ']') {
            Character c5 = lastCharacter;
            if (c5 == null || '\\' != c5.charValue()) {
                return this.compile(StringsKt.drop((String)formatString, (int)1), false, false, Character.valueOf(c2));
            }
        } else if (c == '}') {
            Character c6 = lastCharacter;
            if (c6 == null || '\\' != c6.charValue()) {
                return this.compile(StringsKt.drop((String)formatString, (int)1), false, false, Character.valueOf(c2));
            }
        } else if (c == '\\') {
            Character c7 = lastCharacter;
            if (c7 == null || '\\' != c7.charValue()) {
                return this.compile(StringsKt.drop((String)formatString, (int)1), valuable, fixed, Character.valueOf(c2));
            }
        }
        if (valuable) {
            c = c2;
            if (c == '0') {
                return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c2)), new ValueState.StateType.Numeric());
            }
            if (c == 'A') {
                return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c2)), new ValueState.StateType.Literal());
            }
            if (c == '_') {
                return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c2)), new ValueState.StateType.AlphaNumeric());
            }
            if (c == '\u2026') {
                return new ValueState(this.determineInheritedType(lastCharacter));
            }
            if (c == '9') {
                return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c2)), new OptionalValueState.StateType.Numeric());
            }
            if (c == 'a') {
                return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c2)), new OptionalValueState.StateType.Literal());
            }
            if (c == '-') {
                return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c2)), new OptionalValueState.StateType.AlphaNumeric());
            }
            return this.compileWithCustomNotations(c2, formatString);
        }
        if (fixed) {
            return new FixedState(this.compile(StringsKt.drop((String)formatString, (int)1), false, true, Character.valueOf(c2)), c2);
        }
        return new FreeState(this.compile(StringsKt.drop((String)formatString, (int)1), false, false, Character.valueOf(c2)), c2);
    }

    private final ValueState.StateType determineInheritedType(Character lastCharacter) {
        ValueState.StateType stateType;
        boolean bl;
        Character c;
        Character c2 = c = lastCharacter;
        char c3 = '0';
        if (c2 != null && c2.charValue() == c3) {
            bl = true;
        } else {
            Character c4 = c;
            c3 = '9';
            bl = c4 != null && c4.charValue() == c3;
        }
        if (bl) {
            stateType = new ValueState.StateType.Numeric();
        } else {
            boolean bl2;
            Character c5 = c;
            c3 = 'A';
            if (c5 != null && c5.charValue() == c3) {
                bl2 = true;
            } else {
                Character c6 = c;
                c3 = 'a';
                bl2 = c6 != null && c6.charValue() == c3;
            }
            if (bl2) {
                stateType = new ValueState.StateType.Literal();
            } else {
                boolean bl3;
                Character c7 = c;
                c3 = '_';
                if (c7 != null && c7.charValue() == c3) {
                    bl3 = true;
                } else {
                    Character c8 = c;
                    c3 = '-';
                    bl3 = c8 != null && c8.charValue() == c3;
                }
                if (bl3) {
                    stateType = new ValueState.StateType.AlphaNumeric();
                } else {
                    Character c9 = c;
                    c3 = '\u2026';
                    if (c9 != null && c9.charValue() == c3) {
                        stateType = new ValueState.StateType.AlphaNumeric();
                    } else {
                        Character c10 = c;
                        c3 = '[';
                        stateType = c10 != null && c10.charValue() == c3 ? (ValueState.StateType)new ValueState.StateType.AlphaNumeric() : this.determineTypeWithCustomNotations(lastCharacter);
                    }
                }
            }
        }
        return stateType;
    }

    private final State compileWithCustomNotations(char c, String string) {
        for (Notation customNotation : this.customNotations) {
            if (customNotation.getCharacter() != c) continue;
            return customNotation.isOptional() ? (State)new OptionalValueState(this.compile(StringsKt.drop((String)string, (int)1), true, false, Character.valueOf(c)), new OptionalValueState.StateType.Custom(c, customNotation.getCharacterSet())) : (State)new ValueState(this.compile(StringsKt.drop((String)string, (int)1), true, false, Character.valueOf(c)), new ValueState.StateType.Custom(c, customNotation.getCharacterSet()));
        }
        throw new FormatError();
    }

    private final ValueState.StateType determineTypeWithCustomNotations(Character lastCharacter) {
        Iterable $this$forEach$iv = this.customNotations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Notation notation = (Notation)element$iv;
            boolean bl = false;
            Character c = lastCharacter;
            if (c == null || notation.getCharacter() != c.charValue()) continue;
            return new ValueState.StateType.Custom(lastCharacter.charValue(), notation.getCharacterSet());
        }
        throw new FormatError();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/redmadrobot/inputmask/helper/Compiler$FormatError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "input-mask-android_release"})
    public static final class FormatError
    extends Exception {
    }
}

