/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.FormatSanitizer;
import com.redmadrobot.inputmask.model.Notation;
import com.redmadrobot.inputmask.model.State;
import com.redmadrobot.inputmask.model.state.EOLState;
import com.redmadrobot.inputmask.model.state.FixedState;
import com.redmadrobot.inputmask.model.state.FreeState;
import com.redmadrobot.inputmask.model.state.OptionalValueState;
import com.redmadrobot.inputmask.model.state.ValueState;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J/\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0017\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/redmadrobot/inputmask/helper/Compiler;", "", "customNotations", "", "Lcom/redmadrobot/inputmask/model/Notation;", "(Ljava/util/List;)V", "compile", "Lcom/redmadrobot/inputmask/model/State;", "formatString", "", "valuable", "", "fixed", "lastCharacter", "", "(Ljava/lang/String;ZZLjava/lang/Character;)Lcom/redmadrobot/inputmask/model/State;", "compileWithCustomNotations", "char", "string", "determineInheritedType", "Lcom/redmadrobot/inputmask/model/state/ValueState$StateType;", "(Ljava/lang/Character;)Lcom/redmadrobot/inputmask/model/state/ValueState$StateType;", "determineTypeWithCustomNotations", "FormatError", "inputmask_release"})
public final class Compiler {
    private final List<Notation> customNotations;

    @NotNull
    public final State compile(@NotNull String formatString) throws FormatError {
        Intrinsics.checkParameterIsNotNull((Object)formatString, (String)"formatString");
        String sanitizedString = new FormatSanitizer().sanitize(formatString);
        return this.compile(sanitizedString, false, false, null);
    }

    private final State compile(String formatString, boolean valuable, boolean fixed, Character lastCharacter) {
        CharSequence charSequence = formatString;
        if (charSequence.length() == 0) {
            return new EOLState();
        }
        char c = StringsKt.first((CharSequence)formatString);
        switch (c) {
            case '[': {
                Character c2 = lastCharacter;
                if (c2 != null && '\\' == c2.charValue()) break;
                return this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c));
            }
            case '{': {
                Character c3 = lastCharacter;
                if (c3 != null && '\\' == c3.charValue()) break;
                return this.compile(StringsKt.drop((String)formatString, (int)1), false, true, Character.valueOf(c));
            }
            case ']': {
                Character c4 = lastCharacter;
                if (c4 != null && '\\' == c4.charValue()) break;
                return this.compile(StringsKt.drop((String)formatString, (int)1), false, false, Character.valueOf(c));
            }
            case '}': {
                Character c5 = lastCharacter;
                if (c5 != null && '\\' == c5.charValue()) break;
                return this.compile(StringsKt.drop((String)formatString, (int)1), false, false, Character.valueOf(c));
            }
            case '\\': {
                Character c6 = lastCharacter;
                if (c6 != null && '\\' == c6.charValue()) break;
                return this.compile(StringsKt.drop((String)formatString, (int)1), valuable, fixed, Character.valueOf(c));
            }
        }
        if (valuable) {
            switch (c) {
                case '0': {
                    return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), new ValueState.StateType.Numeric());
                }
                case 'A': {
                    return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), new ValueState.StateType.Literal());
                }
                case '_': {
                    return new ValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), new ValueState.StateType.AlphaNumeric());
                }
                case '\u2026': {
                    return new ValueState(this.determineInheritedType(lastCharacter));
                }
                case '9': {
                    return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), new OptionalValueState.StateType.Numeric());
                }
                case 'a': {
                    return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), new OptionalValueState.StateType.Literal());
                }
                case '-': {
                    return new OptionalValueState(this.compile(StringsKt.drop((String)formatString, (int)1), true, false, Character.valueOf(c)), new OptionalValueState.StateType.AlphaNumeric());
                }
            }
            return this.compileWithCustomNotations(c, formatString);
        }
        if (fixed) {
            return new FixedState(this.compile(StringsKt.drop((String)formatString, (int)1), false, true, Character.valueOf(c)), c);
        }
        return new FreeState(this.compile(StringsKt.drop((String)formatString, (int)1), false, false, Character.valueOf(c)), c);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ValueState.StateType determineInheritedType(Character lastCharacter) {
        ValueState.StateType stateType;
        Character c;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                Character c2 = c = lastCharacter;
                                if (c2 != null && c2.charValue() == '0') break block11;
                                Character c3 = c;
                                if (c3 == null || c3.charValue() != '9') break block12;
                            }
                            stateType = new ValueState.StateType.Numeric();
                            return stateType;
                        }
                        Character c4 = c;
                        if (c4 != null && c4.charValue() == 'A') break block13;
                        Character c5 = c;
                        if (c5 == null || c5.charValue() != 'a') break block14;
                    }
                    stateType = new ValueState.StateType.Literal();
                    return stateType;
                }
                Character c6 = c;
                if (c6 != null && c6.charValue() == '_') break block15;
                Character c7 = c;
                if (c7 == null || c7.charValue() != '-') break block16;
            }
            stateType = new ValueState.StateType.AlphaNumeric();
            return stateType;
        }
        Character c8 = c;
        if (c8 != null && c8.charValue() == '\u2026') {
            stateType = new ValueState.StateType.AlphaNumeric();
            return stateType;
        }
        Character c9 = c;
        if (c9 != null && c9.charValue() == '[') {
            stateType = new ValueState.StateType.AlphaNumeric();
            return stateType;
        }
        stateType = this.determineTypeWithCustomNotations(lastCharacter);
        return stateType;
    }

    private final State compileWithCustomNotations(char c, String string) {
        for (Notation customNotation : this.customNotations) {
            if (customNotation.getCharacter() != c) continue;
            return customNotation.isOptional() ? (State)new OptionalValueState(this.compile(StringsKt.drop((String)string, (int)1), true, false, Character.valueOf(c)), new OptionalValueState.StateType.Custom(c, customNotation.getCharacterSet())) : (State)new ValueState(this.compile(StringsKt.drop((String)string, (int)1), true, false, Character.valueOf(c)), new ValueState.StateType.Custom(c, customNotation.getCharacterSet()));
        }
        throw (Throwable)new FormatError();
    }

    private final ValueState.StateType determineTypeWithCustomNotations(Character lastCharacter) {
        Iterable $receiver$iv = this.customNotations;
        for (Object element$iv : $receiver$iv) {
            Notation notation = (Notation)element$iv;
            Character c = lastCharacter;
            if (c == null || notation.getCharacter() != c.charValue()) continue;
            return new ValueState.StateType.Custom(lastCharacter.charValue(), notation.getCharacterSet());
        }
        throw (Throwable)new FormatError();
    }

    public Compiler(@NotNull List<Notation> customNotations) {
        Intrinsics.checkParameterIsNotNull(customNotations, (String)"customNotations");
        this.customNotations = customNotations;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/redmadrobot/inputmask/helper/Compiler$FormatError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "inputmask_release"})
    public static final class FormatError
    extends Exception {
    }
}

