/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.TriggerMethod;
import java.util.ArrayList;
import java.util.List;

public class CompletedTrigger<TModel>
implements Query {
    private TriggerMethod<TModel> triggerMethod;
    private final List<Query> triggerLogicQuery = new ArrayList<Query>();

    CompletedTrigger(TriggerMethod<TModel> triggerMethod, Query triggerLogicQuery) {
        this.triggerMethod = triggerMethod;
        this.triggerLogicQuery.add(triggerLogicQuery);
    }

    @NonNull
    public CompletedTrigger<TModel> and(@NonNull Query nextStatement) {
        this.triggerLogicQuery.add(nextStatement);
        return this;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)this.triggerMethod.getQuery());
        queryBuilder.append((Object)"\nBEGIN").append((Object)"\n").append((Object)QueryBuilder.join((CharSequence)";\n", this.triggerLogicQuery)).append((Object)";").append((Object)"\nEND");
        return queryBuilder.getQuery();
    }

    public void enable() {
        DatabaseDefinition databaseDefinition = FlowManager.getDatabaseForTable(this.triggerMethod.onTable);
        databaseDefinition.getWritableDatabase().execSQL(this.getQuery());
    }

    public void disable() {
        SqlUtils.dropTrigger(this.triggerMethod.onTable, this.triggerMethod.trigger.triggerName);
    }
}

