/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.saveable;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.runtime.NotifyDistributor;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public class AutoIncrementModelSaver<TModel>
extends ModelSaver<TModel> {
    @Override
    public synchronized long insert(@NonNull TModel model) {
        return this.insert(model, this.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long insert(@NonNull TModel model, @NonNull DatabaseWrapper wrapper) {
        long id;
        boolean hasAutoIncrement = this.getModelAdapter().hasAutoIncrement(model);
        try (DatabaseStatement insertStatement = hasAutoIncrement ? this.getModelAdapter().getCompiledStatement(wrapper) : this.getModelAdapter().getInsertStatement(wrapper);){
            if (hasAutoIncrement) {
                this.getModelAdapter().bindToStatement(insertStatement, model);
            } else {
                this.getModelAdapter().bindToInsertStatement(insertStatement, model);
            }
            id = insertStatement.executeInsert();
            if (id > -1L) {
                this.getModelAdapter().updateAutoIncrement(model, id);
                NotifyDistributor.get().notifyModelChanged(model, this.getModelAdapter(), BaseModel.Action.INSERT);
            }
        }
        return id;
    }

    @Override
    public synchronized long insert(@NonNull TModel model, @NonNull DatabaseStatement insertStatement, @NonNull DatabaseWrapper wrapper) {
        if (this.getModelAdapter().hasAutoIncrement(model)) {
            this.getModelAdapter().bindToStatement(insertStatement, model);
        } else {
            this.getModelAdapter().bindToInsertStatement(insertStatement, model);
        }
        long id = insertStatement.executeInsert();
        if (id > -1L) {
            this.getModelAdapter().updateAutoIncrement(model, id);
            NotifyDistributor.get().notifyModelChanged(model, this.getModelAdapter(), BaseModel.Action.INSERT);
        }
        return id;
    }
}

