/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.BaseAsyncObject;
import com.raizlabs.android.dbflow.structure.Model;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.ProcessModelTransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.lang.ref.WeakReference;

public class AsyncModel<TModel>
extends BaseAsyncObject<AsyncModel<TModel>>
implements Model {
    private final TModel model;
    private transient WeakReference<OnModelChangedListener<TModel>> onModelChangedListener;
    private ModelAdapter<TModel> modelAdapter;

    public AsyncModel(@NonNull TModel referenceModel) {
        super(referenceModel.getClass());
        this.model = referenceModel;
    }

    public AsyncModel<TModel> withListener(OnModelChangedListener<TModel> onModelChangedListener) {
        this.onModelChangedListener = new WeakReference<OnModelChangedListener<TModel>>(onModelChangedListener);
        return this;
    }

    private ModelAdapter<TModel> getModelAdapter() {
        if (this.modelAdapter == null) {
            this.modelAdapter = FlowManager.getModelAdapter(this.model.getClass());
        }
        return this.modelAdapter;
    }

    @Override
    public boolean save(@NonNull DatabaseWrapper wrapper) {
        return this.save();
    }

    @Override
    public boolean save() {
        this.executeTransaction(new ProcessModelTransaction.Builder<TModel>(new ProcessModelTransaction.ProcessModel<TModel>(){

            @Override
            public void processModel(TModel model, DatabaseWrapper wrapper) {
                AsyncModel.this.getModelAdapter().save(model, wrapper);
            }
        }).add(this.model).build());
        return false;
    }

    @Override
    public boolean delete(@NonNull DatabaseWrapper wrapper) {
        return this.delete();
    }

    @Override
    public boolean delete() {
        this.executeTransaction(new ProcessModelTransaction.Builder<TModel>(new ProcessModelTransaction.ProcessModel<TModel>(){

            @Override
            public void processModel(TModel model, DatabaseWrapper wrapper) {
                AsyncModel.this.getModelAdapter().delete(model, wrapper);
            }
        }).add(this.model).build());
        return false;
    }

    @Override
    public boolean update(@NonNull DatabaseWrapper wrapper) {
        return this.update();
    }

    @Override
    public boolean update() {
        this.executeTransaction(new ProcessModelTransaction.Builder<TModel>(new ProcessModelTransaction.ProcessModel<TModel>(){

            @Override
            public void processModel(TModel model, DatabaseWrapper wrapper) {
                AsyncModel.this.getModelAdapter().update(model, wrapper);
            }
        }).add(this.model).build());
        return false;
    }

    @Override
    public long insert(DatabaseWrapper wrapper) {
        return this.insert();
    }

    @Override
    public long insert() {
        this.executeTransaction(new ProcessModelTransaction.Builder<TModel>(new ProcessModelTransaction.ProcessModel<TModel>(){

            @Override
            public void processModel(TModel model, DatabaseWrapper wrapper) {
                AsyncModel.this.getModelAdapter().insert(model, wrapper);
            }
        }).add(this.model).build());
        return -1L;
    }

    @Override
    public void load(DatabaseWrapper wrapper) {
        this.load();
    }

    @Override
    public void load() {
        this.executeTransaction(new ProcessModelTransaction.Builder<TModel>(new ProcessModelTransaction.ProcessModel<TModel>(){

            @Override
            public void processModel(TModel model, DatabaseWrapper wrapper) {
                AsyncModel.this.getModelAdapter().load(model, wrapper);
            }
        }).add(this.model).build());
    }

    @Override
    public boolean exists(DatabaseWrapper wrapper) {
        return this.exists();
    }

    @Override
    public boolean exists() {
        return this.getModelAdapter().exists(this.model);
    }

    @Override
    @NonNull
    public AsyncModel<? extends Model> async() {
        return this;
    }

    @Override
    protected void onSuccess(@NonNull Transaction transaction) {
        if (this.onModelChangedListener != null && this.onModelChangedListener.get() != null) {
            ((OnModelChangedListener)this.onModelChangedListener.get()).onModelChanged(this.model);
        }
    }

    public static interface OnModelChangedListener<T> {
        public void onModelChanged(T var1);
    }
}

