/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.saveable;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.saveable.ListModelSaver;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Collection;

public class CacheableListModelSaver<TModel>
extends ListModelSaver<TModel> {
    public CacheableListModelSaver(ModelSaver<TModel> modelSaver) {
        super(modelSaver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveAll(@NonNull Collection<TModel> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ModelSaver<TModel> modelSaver = this.getModelSaver();
        ModelAdapter<TModel> modelAdapter = modelSaver.getModelAdapter();
        DatabaseStatement statement = modelAdapter.getInsertStatement(wrapper);
        DatabaseStatement updateStatement = modelAdapter.getUpdateStatement(wrapper);
        try {
            for (TModel model : tableCollection) {
                if (!modelSaver.save(model, wrapper, statement, updateStatement)) continue;
                modelAdapter.storeModelInCache(model);
            }
        }
        finally {
            updateStatement.close();
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertAll(@NonNull Collection<TModel> tableCollection, DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ModelSaver<TModel> modelSaver = this.getModelSaver();
        ModelAdapter<TModel> modelAdapter = modelSaver.getModelAdapter();
        try (DatabaseStatement statement = modelAdapter.getInsertStatement(wrapper);){
            for (TModel model : tableCollection) {
                if (modelSaver.insert(model, statement, wrapper) <= 0L) continue;
                modelAdapter.storeModelInCache(model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateAll(@NonNull Collection<TModel> tableCollection, @NonNull DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ModelSaver<TModel> modelSaver = this.getModelSaver();
        ModelAdapter<TModel> modelAdapter = modelSaver.getModelAdapter();
        try (DatabaseStatement statement = modelAdapter.getUpdateStatement(wrapper);){
            for (TModel model : tableCollection) {
                if (!modelSaver.update(model, wrapper, statement)) continue;
                modelAdapter.storeModelInCache(model);
            }
        }
    }

    @Override
    public synchronized void deleteAll(@NonNull Collection<TModel> tableCollection, @NonNull DatabaseWrapper wrapper) {
        if (tableCollection.isEmpty()) {
            return;
        }
        ModelSaver<TModel> modelSaver = this.getModelSaver();
        for (TModel model : tableCollection) {
            if (!modelSaver.delete(model, wrapper)) continue;
            this.getModelSaver().getModelAdapter().removeModelFromCache(model);
        }
    }
}

