/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.IConditional;
import com.raizlabs.android.dbflow.sql.language.IOperator;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.util.Collection;

public class Property<T>
implements IProperty<Property<T>>,
IConditional,
IOperator<T> {
    public static final Property<?> ALL_PROPERTY = new Property<Object>(null, "*"){

        @Override
        public String toString() {
            return this.nameAlias.nameRaw();
        }
    };
    public static final Property<?> WILDCARD = new Property(null, NameAlias.rawBuilder("?").build());
    final Class<?> table;
    protected NameAlias nameAlias;

    public Property(Class<?> table, NameAlias nameAlias) {
        this.table = table;
        this.nameAlias = nameAlias;
    }

    public Property(Class<?> table, String columnName) {
        this.table = table;
        if (columnName != null) {
            this.nameAlias = new NameAlias.Builder(columnName).build();
        }
    }

    public Property(Class<?> table, String columnName, String aliasName) {
        this(table, NameAlias.builder(columnName).as(aliasName).build());
    }

    @Override
    @NonNull
    public Property<T> withTable() {
        return this.withTable(new NameAlias.Builder(FlowManager.getTableName(this.table)).build());
    }

    @Override
    @NonNull
    public NameAlias getNameAlias() {
        return this.nameAlias;
    }

    public String getQuery() {
        return this.getNameAlias().getQuery();
    }

    @Override
    @NonNull
    public String getCursorKey() {
        return this.getNameAlias().getQuery();
    }

    public String getDefinition() {
        return this.getNameAlias().getFullQuery();
    }

    public String toString() {
        return this.getNameAlias().toString();
    }

    @Override
    @NonNull
    public Operator is(IConditional conditional) {
        return this.getCondition().is(conditional);
    }

    @Override
    @NonNull
    public Operator eq(IConditional conditional) {
        return this.getCondition().eq(conditional);
    }

    @Override
    @NonNull
    public Operator isNot(IConditional conditional) {
        return this.getCondition().isNot(conditional);
    }

    @Override
    @NonNull
    public Operator notEq(IConditional conditional) {
        return this.getCondition().notEq(conditional);
    }

    @Override
    @NonNull
    public Operator like(IConditional conditional) {
        return this.getCondition().like(conditional);
    }

    @Override
    @NonNull
    public Operator glob(IConditional conditional) {
        return this.getCondition().glob(conditional);
    }

    @Override
    @NonNull
    public Operator<T> like(String value) {
        return this.getCondition().like(value);
    }

    @Override
    @NonNull
    public Operator<T> notLike(String value) {
        return this.getCondition().notLike(value);
    }

    @Override
    @NonNull
    public Operator<T> glob(String value) {
        return this.getCondition().glob(value);
    }

    @Override
    @NonNull
    public Operator greaterThan(IConditional conditional) {
        return this.getCondition().greaterThan(conditional);
    }

    @Override
    @NonNull
    public Operator greaterThanOrEq(IConditional conditional) {
        return this.getCondition().greaterThanOrEq(conditional);
    }

    @Override
    @NonNull
    public Operator lessThan(IConditional conditional) {
        return this.getCondition().lessThan(conditional);
    }

    @Override
    @NonNull
    public Operator lessThanOrEq(IConditional conditional) {
        return this.getCondition().lessThanOrEq(conditional);
    }

    @Override
    @NonNull
    public Operator.Between between(IConditional conditional) {
        return this.getCondition().between(conditional);
    }

    @Override
    @NonNull
    public Operator.In in(IConditional firstConditional, IConditional ... conditionals) {
        return this.getCondition().in(firstConditional, conditionals);
    }

    @Override
    @NonNull
    public Operator.In notIn(IConditional firstConditional, IConditional ... conditionals) {
        return this.getCondition().notIn(firstConditional, conditionals);
    }

    @Override
    @NonNull
    public Operator is(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().is(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator isNull() {
        return this.getCondition().isNull();
    }

    @Override
    @NonNull
    public Operator eq(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().eq(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator isNot(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().isNot(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator isNotNull() {
        return this.getCondition().isNotNull();
    }

    @Override
    @NonNull
    public Operator notEq(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().notEq(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator like(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().like(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator notLike(IConditional conditional) {
        return this.getCondition().notLike(conditional);
    }

    @Override
    @NonNull
    public Operator notLike(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().notLike(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator glob(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().glob(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator greaterThan(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().greaterThan(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator greaterThanOrEq(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().greaterThanOrEq(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator lessThan(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().lessThan(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator lessThanOrEq(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().lessThanOrEq(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator.Between between(BaseModelQueriable baseModelQueriable) {
        return this.getCondition().between(baseModelQueriable);
    }

    @Override
    @NonNull
    public Operator.In in(BaseModelQueriable firstBaseModelQueriable, BaseModelQueriable ... baseModelQueriables) {
        return this.getCondition().in(firstBaseModelQueriable, baseModelQueriables);
    }

    @Override
    @NonNull
    public Operator.In notIn(BaseModelQueriable firstBaseModelQueriable, BaseModelQueriable ... baseModelQueriables) {
        return this.getCondition().notIn(firstBaseModelQueriable, baseModelQueriables);
    }

    @Override
    @NonNull
    public Operator concatenate(IConditional conditional) {
        return this.getCondition().concatenate(conditional);
    }

    @Override
    @NonNull
    public Operator plus(BaseModelQueriable value) {
        return this.getCondition().plus(value);
    }

    @Override
    @NonNull
    public Operator minus(BaseModelQueriable value) {
        return this.getCondition().minus(value);
    }

    @Override
    @NonNull
    public Operator div(BaseModelQueriable value) {
        return this.getCondition().div(value);
    }

    @Override
    @NonNull
    public Operator times(BaseModelQueriable value) {
        return this.getCondition().times(value);
    }

    @Override
    @NonNull
    public Operator rem(BaseModelQueriable value) {
        return this.getCondition().rem(value);
    }

    @Override
    @NonNull
    public Class<?> getTable() {
        return this.table;
    }

    @Override
    @NonNull
    public Property<T> plus(IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("+", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> minus(IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("-", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> div(IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public Property<T> times(IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("*", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> rem(IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("%", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> concatenate(IProperty iProperty) {
        return new Property<T>(this.table, NameAlias.joinNames("||", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    @NonNull
    public Property<T> as(String aliasName) {
        return new Property<T>(this.table, this.getNameAlias().newBuilder().as(aliasName).build());
    }

    @Override
    @NonNull
    public Property<T> distinct() {
        return new Property<T>(this.table, this.getDistinctAliasName());
    }

    @Override
    @NonNull
    public Property<T> withTable(NameAlias tableNameAlias) {
        return new Property<T>(this.table, this.getNameAlias().newBuilder().withTable(tableNameAlias.getQuery()).build());
    }

    @Override
    @NonNull
    public Operator<T> is(T value) {
        return this.getCondition().is(value);
    }

    @Override
    @NonNull
    public Operator<T> eq(T value) {
        return this.getCondition().eq(value);
    }

    @Override
    @NonNull
    public Operator<T> isNot(T value) {
        return this.getCondition().isNot(value);
    }

    @Override
    @NonNull
    public Operator<T> notEq(T value) {
        return this.getCondition().notEq(value);
    }

    @Override
    @NonNull
    public Operator<T> greaterThan(T value) {
        return this.getCondition().greaterThan(value);
    }

    @Override
    @NonNull
    public Operator<T> greaterThanOrEq(T value) {
        return this.getCondition().greaterThanOrEq(value);
    }

    @Override
    @NonNull
    public Operator<T> lessThan(T value) {
        return this.getCondition().lessThan(value);
    }

    @Override
    @NonNull
    public Operator<T> lessThanOrEq(T value) {
        return this.getCondition().lessThanOrEq(value);
    }

    @Override
    @NonNull
    public Operator.Between<T> between(T value) {
        return this.getCondition().between(value);
    }

    @Override
    @NonNull
    public Operator.In<T> in(T firstValue, T ... values) {
        return this.getCondition().in(firstValue, values);
    }

    @Override
    @NonNull
    public Operator.In<T> notIn(T firstValue, T ... values) {
        return this.getCondition().notIn(firstValue, values);
    }

    @Override
    @NonNull
    public Operator.In<T> in(Collection<T> values) {
        return this.getCondition().in(values);
    }

    @Override
    @NonNull
    public Operator.In<T> notIn(Collection<T> values) {
        return this.getCondition().notIn(values);
    }

    @Override
    @NonNull
    public Operator<T> concatenate(T value) {
        return this.getCondition().concatenate((Object)value);
    }

    @Override
    @NonNull
    public Operator<T> plus(T value) {
        return this.getCondition().plus(value);
    }

    @Override
    @NonNull
    public Operator<T> minus(T value) {
        return this.getCondition().minus(value);
    }

    @Override
    @NonNull
    public Operator<T> div(T value) {
        return this.getCondition().div(value);
    }

    @Override
    public Operator<T> times(T value) {
        return this.getCondition().times(value);
    }

    @Override
    @NonNull
    public Operator<T> rem(T value) {
        return this.getCondition().rem(value);
    }

    @Override
    @NonNull
    public OrderBy asc() {
        return OrderBy.fromProperty(this).ascending();
    }

    @Override
    @NonNull
    public OrderBy desc() {
        return OrderBy.fromProperty(this).descending();
    }

    protected NameAlias getDistinctAliasName() {
        return this.getNameAlias().newBuilder().distinct().build();
    }

    protected Operator<T> getCondition() {
        return Operator.op(this.getNameAlias());
    }
}

