/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.ExistenceOperator;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Transformable;
import com.raizlabs.android.dbflow.sql.language.WhereBase;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Where<TModel>
extends BaseModelQueriable<TModel>
implements ModelQueriable<TModel>,
Transformable<TModel> {
    private static final int VALUE_UNSET = -1;
    private final WhereBase<TModel> whereBase;
    private OperatorGroup operatorGroup;
    private final List<NameAlias> groupByList = new ArrayList<NameAlias>();
    private final List<OrderBy> orderByList = new ArrayList<OrderBy>();
    private OperatorGroup havingGroup;
    private int limit = -1;
    private int offset = -1;

    public Where(WhereBase<TModel> whereBase, SQLOperator ... conditions) {
        super(whereBase.getTable());
        this.whereBase = whereBase;
        this.operatorGroup = OperatorGroup.nonGroupingClause();
        this.havingGroup = OperatorGroup.nonGroupingClause();
        this.operatorGroup.andAll(conditions);
    }

    @NonNull
    public Where<TModel> and(SQLOperator condition) {
        this.operatorGroup.and(condition);
        return this;
    }

    @NonNull
    public Where<TModel> or(SQLOperator condition) {
        this.operatorGroup.or(condition);
        return this;
    }

    @NonNull
    public Where<TModel> andAll(List<SQLOperator> conditions) {
        this.operatorGroup.andAll(conditions);
        return this;
    }

    @NonNull
    public Where<TModel> andAll(SQLOperator ... conditions) {
        this.operatorGroup.andAll(conditions);
        return this;
    }

    @Override
    @NonNull
    public Where<TModel> groupBy(NameAlias ... columns) {
        Collections.addAll(this.groupByList, columns);
        return this;
    }

    @Override
    @NonNull
    public Where<TModel> groupBy(IProperty ... properties) {
        for (IProperty property : properties) {
            this.groupByList.add(property.getNameAlias());
        }
        return this;
    }

    @Override
    @NonNull
    public Where<TModel> having(SQLOperator ... conditions) {
        this.havingGroup.andAll(conditions);
        return this;
    }

    @Override
    @NonNull
    public Where<TModel> orderBy(NameAlias nameAlias, boolean ascending) {
        this.orderByList.add(new OrderBy(nameAlias, ascending));
        return this;
    }

    @Override
    @NonNull
    public Where<TModel> orderBy(IProperty property, boolean ascending) {
        this.orderByList.add(new OrderBy(property.getNameAlias(), ascending));
        return this;
    }

    @Override
    @NonNull
    public Where<TModel> orderBy(OrderBy orderBy) {
        this.orderByList.add(orderBy);
        return this;
    }

    @Override
    @NonNull
    public Where<TModel> orderByAll(List<OrderBy> orderBies) {
        if (orderBies != null) {
            this.orderByList.addAll(orderBies);
        }
        return this;
    }

    @Override
    @NonNull
    public Where<TModel> limit(int count) {
        this.limit = count;
        return this;
    }

    @Override
    @NonNull
    public Where<TModel> offset(int offset) {
        this.offset = offset;
        return this;
    }

    @NonNull
    public Where<TModel> exists(@NonNull Where where) {
        this.operatorGroup.and(new ExistenceOperator().where(where));
        return this;
    }

    @Override
    public BaseModel.Action getPrimaryAction() {
        return this.whereBase.getPrimaryAction();
    }

    public String getQuery() {
        String fromQuery = this.whereBase.getQuery().trim();
        QueryBuilder queryBuilder = new QueryBuilder().append((Object)fromQuery).appendSpace().appendQualifier("WHERE", this.operatorGroup.getQuery()).appendQualifier("GROUP BY", QueryBuilder.join((CharSequence)",", this.groupByList)).appendQualifier("HAVING", this.havingGroup.getQuery()).appendQualifier("ORDER BY", QueryBuilder.join((CharSequence)",", this.orderByList));
        if (this.limit > -1) {
            queryBuilder.appendQualifier("LIMIT", String.valueOf(this.limit));
        }
        if (this.offset > -1) {
            queryBuilder.appendQualifier("OFFSET", String.valueOf(this.offset));
        }
        return queryBuilder.getQuery();
    }

    @Override
    public FlowCursor query(DatabaseWrapper wrapper) {
        FlowCursor cursor = this.whereBase.getQueryBuilderBase() instanceof Select ? wrapper.rawQuery(this.getQuery(), null) : super.query(wrapper);
        return cursor;
    }

    @Override
    public FlowCursor query() {
        return this.query(FlowManager.getDatabaseForTable(this.getTable()).getWritableDatabase());
    }

    @Override
    @NonNull
    public List<TModel> queryList() {
        this.checkSelect("query");
        return super.queryList();
    }

    @Override
    public TModel querySingle() {
        this.checkSelect("query");
        this.limit(1);
        return super.querySingle();
    }

    public WhereBase<TModel> getWhereBase() {
        return this.whereBase;
    }

    private void checkSelect(String methodName) {
        if (!(this.whereBase.getQueryBuilderBase() instanceof Select)) {
            throw new IllegalArgumentException("Please use " + methodName + "(). The beginning is not a ISelect");
        }
    }
}

