/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.list.FlowCursorList;
import com.raizlabs.android.dbflow.list.FlowQueryList;
import com.raizlabs.android.dbflow.runtime.NotifyDistributor;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.language.BaseQueriable;
import com.raizlabs.android.dbflow.sql.language.CursorResult;
import com.raizlabs.android.dbflow.sql.queriable.AsyncQuery;
import com.raizlabs.android.dbflow.sql.queriable.ListModelLoader;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.sql.queriable.SingleModelLoader;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import com.raizlabs.android.dbflow.structure.QueryModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.List;

public abstract class BaseModelQueriable<TModel>
extends BaseQueriable<TModel>
implements ModelQueriable<TModel>,
Query {
    private InstanceAdapter<TModel> retrievalAdapter;
    private boolean cachingEnabled = true;

    protected BaseModelQueriable(Class<TModel> table) {
        super(table);
    }

    private InstanceAdapter<TModel> getRetrievalAdapter() {
        if (this.retrievalAdapter == null) {
            this.retrievalAdapter = FlowManager.getInstanceAdapter(this.getTable());
        }
        return this.retrievalAdapter;
    }

    @Override
    @NonNull
    public CursorResult<TModel> queryResults() {
        return new CursorResult(this.getRetrievalAdapter().getModelClass(), (Cursor)this.query());
    }

    @Override
    @NonNull
    public List<TModel> queryList() {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        return this.getListModelLoader().load(query);
    }

    @Override
    @Nullable
    public TModel querySingle() {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        return (TModel)this.getSingleModelLoader().load(query);
    }

    @Override
    public TModel querySingle(DatabaseWrapper wrapper) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        return (TModel)this.getSingleModelLoader().load(wrapper, query);
    }

    @Override
    @NonNull
    public List<TModel> queryList(DatabaseWrapper wrapper) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        return this.getListModelLoader().load(wrapper, query);
    }

    @Override
    @NonNull
    public FlowCursorList<TModel> cursorList() {
        return new FlowCursorList.Builder(this.getTable()).cacheModels(this.cachingEnabled).modelQueriable(this).build();
    }

    @Override
    @NonNull
    public FlowQueryList<TModel> flowQueryList() {
        return new FlowQueryList.Builder(this.getTable()).cacheModels(this.cachingEnabled).modelQueriable(this).build();
    }

    @Override
    public long executeUpdateDelete() {
        return this.executeUpdateDelete(FlowManager.getWritableDatabaseForTable(this.getTable()));
    }

    @Override
    public long executeUpdateDelete(DatabaseWrapper databaseWrapper) {
        long affected = databaseWrapper.compileStatement(this.getQuery()).executeUpdateDelete();
        if (affected > 0L) {
            NotifyDistributor.get().notifyTableChanged(this.getTable(), this.getPrimaryAction());
        }
        return affected;
    }

    @Override
    @NonNull
    public AsyncQuery<TModel> async() {
        return new AsyncQuery(this);
    }

    @Override
    @NonNull
    public <QueryClass> List<QueryClass> queryCustomList(Class<QueryClass> queryModelClass) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        QueryModelAdapter<QueryClass> adapter = FlowManager.getQueryModelAdapter(queryModelClass);
        return this.cachingEnabled ? adapter.getListModelLoader().load(query) : adapter.getNonCacheableListModelLoader().load(query);
    }

    @Override
    @Nullable
    public <QueryClass> QueryClass queryCustomSingle(Class<QueryClass> queryModelClass) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        QueryModelAdapter<QueryClass> adapter = FlowManager.getQueryModelAdapter(queryModelClass);
        return (QueryClass)(this.cachingEnabled ? adapter.getSingleModelLoader().load(query) : adapter.getNonCacheableSingleModelLoader().load(query));
    }

    @Override
    @NonNull
    public ModelQueriable<TModel> disableCaching() {
        this.cachingEnabled = false;
        return this;
    }

    private ListModelLoader<TModel> getListModelLoader() {
        return this.cachingEnabled ? this.getRetrievalAdapter().getListModelLoader() : this.getRetrievalAdapter().getNonCacheableListModelLoader();
    }

    private SingleModelLoader<TModel> getSingleModelLoader() {
        return this.cachingEnabled ? this.getRetrievalAdapter().getSingleModelLoader() : this.getRetrievalAdapter().getNonCacheableSingleModelLoader();
    }
}

