/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql;

import android.content.ContentValues;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.runtime.NotifyDistributor;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Map;
import java.util.Set;

public class SqlUtils {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    @Deprecated
    public static void notifyModelChanged(Class<?> table, BaseModel.Action action, Iterable<SQLOperator> sqlOperators) {
        FlowManager.getContext().getContentResolver().notifyChange(SqlUtils.getNotificationUri(table, action, sqlOperators), null, true);
    }

    @Deprecated
    public static <TModel> void notifyModelChanged(@Nullable TModel model, @NonNull ModelAdapter<TModel> modelAdapter, @NonNull BaseModel.Action action) {
        NotifyDistributor.get().notifyModelChanged(model, modelAdapter, action);
    }

    @Deprecated
    public static <TModel> void notifyTableChanged(@NonNull Class<TModel> table, @NonNull BaseModel.Action action) {
        NotifyDistributor.get().notifyTableChanged(table, action);
    }

    public static Uri getNotificationUri(Class<?> modelClass, BaseModel.Action action, Iterable<SQLOperator> conditions) {
        Uri.Builder uriBuilder = new Uri.Builder().scheme("dbflow").authority(FlowManager.getTableName(modelClass));
        if (action != null) {
            uriBuilder.fragment(action.name());
        }
        if (conditions != null) {
            for (SQLOperator condition : conditions) {
                uriBuilder.appendQueryParameter(Uri.encode((String)condition.columnName()), Uri.encode((String)String.valueOf(condition.value())));
            }
        }
        return uriBuilder.build();
    }

    public static Uri getNotificationUri(Class<?> modelClass, BaseModel.Action action, @Nullable SQLOperator[] conditions) {
        Uri.Builder uriBuilder = new Uri.Builder().scheme("dbflow").authority(FlowManager.getTableName(modelClass));
        if (action != null) {
            uriBuilder.fragment(action.name());
        }
        if (conditions != null && conditions.length > 0) {
            for (SQLOperator condition : conditions) {
                if (condition == null) continue;
                uriBuilder.appendQueryParameter(Uri.encode((String)condition.columnName()), Uri.encode((String)String.valueOf(condition.value())));
            }
        }
        return uriBuilder.build();
    }

    public static Uri getNotificationUri(Class<?> modelClass, BaseModel.Action action, String notifyKey, Object notifyValue) {
        Operator operator = null;
        if (StringUtils.isNotNullOrEmpty((String)notifyKey)) {
            operator = Operator.op(new NameAlias.Builder(notifyKey).build()).value(notifyValue);
        }
        return SqlUtils.getNotificationUri(modelClass, action, new SQLOperator[]{operator});
    }

    public static Uri getNotificationUri(Class<?> modelClass, BaseModel.Action action) {
        return SqlUtils.getNotificationUri(modelClass, action, null, null);
    }

    public static void dropTrigger(Class<?> mOnTable, String triggerName) {
        QueryBuilder queryBuilder = new QueryBuilder((Object)"DROP TRIGGER IF EXISTS ").append((Object)triggerName);
        FlowManager.getDatabaseForTable(mOnTable).getWritableDatabase().execSQL(queryBuilder.getQuery());
    }

    public static void dropIndex(DatabaseWrapper databaseWrapper, String indexName) {
        QueryBuilder queryBuilder = new QueryBuilder((Object)"DROP INDEX IF EXISTS ").append((Object)QueryBuilder.quoteIfNeeded((String)indexName));
        databaseWrapper.execSQL(queryBuilder.getQuery());
    }

    public static void dropIndex(Class<?> onTable, String indexName) {
        SqlUtils.dropIndex(FlowManager.getDatabaseForTable(onTable).getWritableDatabase(), indexName);
    }

    public static void addContentValues(@NonNull ContentValues contentValues, @NonNull OperatorGroup operatorGroup) {
        Set entries = contentValues.valueSet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            operatorGroup.and(Operator.op(new NameAlias.Builder(key).build()).is(contentValues.get(key)));
        }
    }

    public static String getContentValuesKey(ContentValues contentValues, String key) {
        String quoted = QueryBuilder.quoteIfNeeded((String)key);
        if (contentValues.containsKey(quoted)) {
            return quoted;
        }
        String stripped = QueryBuilder.stripQuotes((String)key);
        if (contentValues.containsKey(stripped)) {
            return stripped;
        }
        throw new IllegalArgumentException("Could not find the specified key in the Content Values object.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long longForQuery(DatabaseWrapper wrapper, String query) {
        try (DatabaseStatement statement = wrapper.compileStatement(query);){
            long l = statement.simpleQueryForLong();
            return l;
        }
    }

    public static String byteArrayToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

