/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.os.Build;
import com.raizlabs.android.dbflow.structure.database.BaseDatabaseStatement;

public class AndroidDatabaseStatement
extends BaseDatabaseStatement {
    private final SQLiteStatement statement;
    private final SQLiteDatabase database;

    public static AndroidDatabaseStatement from(SQLiteStatement sqLiteStatement, SQLiteDatabase database) {
        return new AndroidDatabaseStatement(sqLiteStatement, database);
    }

    AndroidDatabaseStatement(SQLiteStatement statement, SQLiteDatabase database) {
        this.statement = statement;
        this.database = database;
    }

    public SQLiteStatement getStatement() {
        return this.statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeUpdateDelete() {
        long count = 0L;
        if (Build.VERSION.SDK_INT >= 11) {
            count = this.statement.executeUpdateDelete();
        } else {
            this.statement.execute();
            try (Cursor cursor = null;){
                cursor = this.database.rawQuery("SELECT changes() AS affected_row_count", null);
                if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                    count = cursor.getLong(cursor.getColumnIndex("affected_row_count"));
                }
            }
        }
        return count;
    }

    @Override
    public void execute() {
        this.statement.execute();
    }

    @Override
    public void close() {
        this.statement.close();
    }

    @Override
    public long simpleQueryForLong() {
        return this.statement.simpleQueryForLong();
    }

    @Override
    public String simpleQueryForString() {
        return this.statement.simpleQueryForString();
    }

    @Override
    public long executeInsert() {
        return this.statement.executeInsert();
    }

    @Override
    public void bindString(int index, String s) {
        this.statement.bindString(index, s);
    }

    @Override
    public void bindNull(int index) {
        this.statement.bindNull(index);
    }

    @Override
    public void bindLong(int index, long aLong) {
        this.statement.bindLong(index, aLong);
    }

    @Override
    public void bindDouble(int index, double aDouble) {
        this.statement.bindDouble(index, aDouble);
    }

    @Override
    public void bindBlob(int index, byte[] bytes) {
        this.statement.bindBlob(index, bytes);
    }
}

