/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.migration;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.language.Index;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.migration.BaseMigration;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public abstract class IndexMigration<TModel>
extends BaseMigration {
    private Class<TModel> onTable;
    private String name;
    private Index<TModel> index;

    public IndexMigration(@NonNull Class<TModel> onTable) {
        this.onTable = onTable;
    }

    @NonNull
    public abstract String getName();

    @Override
    @CallSuper
    public void onPreMigrate() {
        this.index = this.getIndex();
    }

    @Override
    public final void migrate(DatabaseWrapper database) {
        database.execSQL(this.getIndex().getQuery());
    }

    @Override
    @CallSuper
    public void onPostMigrate() {
        this.onTable = null;
        this.name = null;
        this.index = null;
    }

    public IndexMigration<TModel> addColumn(IProperty property) {
        this.getIndex().and(property);
        return this;
    }

    public IndexMigration<TModel> unique() {
        this.getIndex().unique(true);
        return this;
    }

    public Index<TModel> getIndex() {
        if (this.index == null) {
            this.index = new Index<TModel>(this.name).on(this.onTable, new IProperty[0]);
        }
        return this.index;
    }

    public String getIndexQuery() {
        return this.getIndex().getQuery();
    }
}

