/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.runtime;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.DatabaseHolder;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;

public abstract class BaseContentProvider
extends ContentProvider {
    protected Class<? extends DatabaseHolder> moduleClass;
    protected DatabaseDefinition database;

    protected BaseContentProvider() {
    }

    protected BaseContentProvider(Class<? extends DatabaseHolder> databaseHolderClass) {
        this.moduleClass = databaseHolderClass;
    }

    public boolean onCreate() {
        if (this.moduleClass != null) {
            FlowManager.initModule(this.moduleClass);
        }
        return true;
    }

    public int bulkInsert(final @NonNull Uri uri, final @NonNull ContentValues[] values) {
        final int[] count = new int[]{0};
        this.getDatabase().executeTransaction(new ITransaction(){

            @Override
            public void execute(DatabaseWrapper databaseWrapper) {
                for (ContentValues contentValues : values) {
                    count[0] = count[0] + BaseContentProvider.this.bulkInsert(uri, contentValues);
                }
            }
        });
        this.getContext().getContentResolver().notifyChange(uri, null);
        return count[0];
    }

    protected abstract String getDatabaseName();

    protected abstract int bulkInsert(Uri var1, ContentValues var2);

    protected DatabaseDefinition getDatabase() {
        if (this.database == null) {
            this.database = FlowManager.getDatabase(this.getDatabaseName());
        }
        return this.database;
    }

    public static interface PropertyConverter {
        public IProperty fromName(String var1);
    }
}

