/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import com.raizlabs.android.dbflow.annotation.Collate;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class OrderBy
implements Query {
    public static final String ASCENDING = "ASC";
    public static final String DESCENDING = "DESC";
    private NameAlias column;
    private boolean isAscending;
    private Collate collation;
    private String orderByString;

    public static OrderBy fromProperty(IProperty property) {
        return new OrderBy(property.getNameAlias());
    }

    public static OrderBy fromNameAlias(NameAlias nameAlias) {
        return new OrderBy(nameAlias);
    }

    public static OrderBy fromString(String orderByString) {
        return new OrderBy(orderByString);
    }

    OrderBy(NameAlias column) {
        this.column = column;
    }

    OrderBy(NameAlias column, boolean isAscending) {
        this(column);
        this.isAscending = isAscending;
    }

    OrderBy(String orderByString) {
        this.orderByString = orderByString;
    }

    public OrderBy ascending() {
        this.isAscending = true;
        return this;
    }

    public OrderBy descending() {
        this.isAscending = false;
        return this;
    }

    public OrderBy collate(Collate collate) {
        this.collation = collate;
        return this;
    }

    public String getQuery() {
        if (this.orderByString == null) {
            StringBuilder query = new StringBuilder().append(this.column).append(" ");
            if (this.collation != null) {
                query.append("COLLATE").append(" ").append(this.collation).append(" ");
            }
            query.append(this.isAscending ? ASCENDING : DESCENDING);
            return query.toString();
        }
        return this.orderByString;
    }

    public String toString() {
        return this.getQuery();
    }
}

