/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.trigger;

import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.trigger.CompletedTrigger;
import com.raizlabs.android.dbflow.sql.trigger.Trigger;

public class TriggerMethod<TModel>
implements Query {
    public static final String DELETE = "DELETE";
    public static final String INSERT = "INSERT";
    public static final String UPDATE = "UPDATE";
    final Trigger trigger;
    private IProperty[] properties;
    private final String methodName;
    Class<TModel> onTable;
    boolean forEachRow = false;
    private SQLCondition whenCondition;

    TriggerMethod(Trigger trigger, String methodName, Class<TModel> onTable, IProperty ... properties) {
        this.trigger = trigger;
        this.methodName = methodName;
        this.onTable = onTable;
        if (properties != null && properties.length > 0 && properties[0] != null) {
            if (!methodName.equals(UPDATE)) {
                throw new IllegalArgumentException("An Trigger OF can only be used with an UPDATE method");
            }
            this.properties = properties;
        }
    }

    public TriggerMethod<TModel> forEachRow() {
        this.forEachRow = true;
        return this;
    }

    public TriggerMethod<TModel> when(SQLCondition condition) {
        this.whenCondition = condition;
        return this;
    }

    public CompletedTrigger<TModel> begin(Query triggerLogicQuery) {
        return new CompletedTrigger(this, triggerLogicQuery);
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)this.trigger.getQuery()).append((Object)this.methodName);
        if (this.properties != null && this.properties.length > 0) {
            queryBuilder.appendSpaceSeparated((Object)"OF").appendArray((Object[])this.properties);
        }
        queryBuilder.appendSpaceSeparated((Object)"ON").append((Object)FlowManager.getTableName(this.onTable));
        if (this.forEachRow) {
            queryBuilder.appendSpaceSeparated((Object)"FOR EACH ROW");
        }
        if (this.whenCondition != null) {
            queryBuilder.append((Object)" WHEN ");
            this.whenCondition.appendConditionToQuery(queryBuilder);
            queryBuilder.appendSpace();
        }
        queryBuilder.appendSpace();
        return queryBuilder.getQuery();
    }
}

