/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class LongProperty
extends BaseProperty<LongProperty> {
    public LongProperty(Class<?> table, NameAlias nameAlias) {
        super(table, nameAlias);
    }

    public LongProperty(Class<?> table, String columnName) {
        this(table, new NameAlias.Builder(columnName).build());
    }

    public LongProperty(Class<?> table, String columnName, String aliasName) {
        this(table, new NameAlias.Builder(columnName).as(aliasName).build());
    }

    @Override
    public LongProperty plus(IProperty iProperty) {
        return new LongProperty(this.table, NameAlias.joinNames("+", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public LongProperty minus(IProperty iProperty) {
        return new LongProperty(this.table, NameAlias.joinNames("-", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public LongProperty dividedBy(IProperty iProperty) {
        return new LongProperty(this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public LongProperty multipliedBy(IProperty iProperty) {
        return new LongProperty(this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public LongProperty mod(IProperty iProperty) {
        return new LongProperty(this.table, NameAlias.joinNames("%", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public LongProperty concatenate(IProperty iProperty) {
        return new LongProperty(this.table, NameAlias.joinNames("||", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public LongProperty as(String aliasName) {
        return new LongProperty(this.table, this.nameAlias.newBuilder().as(aliasName).build());
    }

    @Override
    public LongProperty distinct() {
        return new LongProperty(this.table, this.getDistinctAliasName());
    }

    @Override
    public LongProperty withTable(NameAlias tableNameAlias) {
        return new LongProperty(this.table, this.nameAlias.newBuilder().withTable(tableNameAlias.getQuery()).build());
    }

    public Condition is(long value) {
        return Condition.column(this.nameAlias).is((Object)value);
    }

    public Condition eq(long value) {
        return Condition.column(this.nameAlias).eq((Object)value);
    }

    public Condition isNot(long value) {
        return Condition.column(this.nameAlias).isNot((Object)value);
    }

    public Condition notEq(long value) {
        return Condition.column(this.nameAlias).notEq((Object)value);
    }

    public Condition like(long value) {
        return Condition.column(this.nameAlias).like(String.valueOf(value));
    }

    public Condition notLike(long value) {
        return Condition.column(this.nameAlias).notLike(String.valueOf(value));
    }

    public Condition glob(long value) {
        return Condition.column(this.nameAlias).glob(String.valueOf(value));
    }

    public Condition greaterThan(long value) {
        return Condition.column(this.nameAlias).greaterThan((Object)value);
    }

    public Condition greaterThanOrEq(long value) {
        return Condition.column(this.nameAlias).greaterThanOrEq((Object)value);
    }

    public Condition lessThan(long value) {
        return Condition.column(this.nameAlias).lessThan((Object)value);
    }

    public Condition lessThanOrEq(long value) {
        return Condition.column(this.nameAlias).lessThanOrEq((Object)value);
    }

    public Condition.Between between(long value) {
        return Condition.column(this.nameAlias).between((Object)value);
    }

    public Condition.In in(long firstValue, long ... values) {
        Condition.In in = Condition.column(this.nameAlias).in((Object)firstValue, new Object[0]);
        for (long value : values) {
            in.and(value);
        }
        return in;
    }

    public Condition.In notIn(long firstValue, long ... values) {
        Condition.In in = Condition.column(this.nameAlias).notIn((Object)firstValue, new Object[0]);
        for (long value : values) {
            in.and(value);
        }
        return in;
    }

    public Condition concatenate(long value) {
        return Condition.column(this.nameAlias).concatenate((Object)value);
    }

    public Condition is(LongProperty property) {
        return Condition.column(this.nameAlias).is(property);
    }

    public Condition isNot(LongProperty property) {
        return Condition.column(this.nameAlias).isNot(property);
    }

    public Condition eq(LongProperty property) {
        return this.is(property);
    }

    public Condition notEq(LongProperty property) {
        return this.isNot(property);
    }

    public Condition greaterThan(LongProperty property) {
        return Condition.column(this.nameAlias).greaterThan(property);
    }

    public Condition greaterThanOrEq(LongProperty property) {
        return Condition.column(this.nameAlias).greaterThanOrEq(property);
    }

    public Condition lessThan(LongProperty property) {
        return Condition.column(this.nameAlias).lessThan(property);
    }

    public Condition lessThanOrEq(LongProperty property) {
        return Condition.column(this.nameAlias).lessThanOrEq(property);
    }
}

