/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class DoubleProperty
extends BaseProperty<DoubleProperty> {
    public DoubleProperty(Class<?> table, NameAlias nameAlias) {
        super(table, nameAlias);
    }

    public DoubleProperty(Class<?> table, String columnName) {
        this(table, new NameAlias.Builder(columnName).build());
    }

    public DoubleProperty(Class<?> table, String columnName, String aliasName) {
        this(table, new NameAlias.Builder(columnName).as(aliasName).build());
    }

    @Override
    public DoubleProperty plus(IProperty iProperty) {
        return new DoubleProperty(this.table, NameAlias.joinNames("+", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public DoubleProperty minus(IProperty iProperty) {
        return new DoubleProperty(this.table, NameAlias.joinNames("-", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public DoubleProperty dividedBy(IProperty iProperty) {
        return new DoubleProperty(this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public DoubleProperty multipliedBy(IProperty iProperty) {
        return new DoubleProperty(this.table, NameAlias.joinNames("*", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public DoubleProperty mod(IProperty iProperty) {
        return new DoubleProperty(this.table, NameAlias.joinNames("%", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public DoubleProperty concatenate(IProperty iProperty) {
        return new DoubleProperty(this.table, NameAlias.joinNames("||", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public DoubleProperty as(String aliasName) {
        return new DoubleProperty(this.table, this.nameAlias.newBuilder().as(aliasName).build());
    }

    @Override
    public DoubleProperty distinct() {
        return new DoubleProperty(this.table, this.getDistinctAliasName());
    }

    @Override
    public DoubleProperty withTable(NameAlias tableNameAlias) {
        return new DoubleProperty(this.table, this.nameAlias.newBuilder().withTable(tableNameAlias.getQuery()).build());
    }

    public Condition is(double value) {
        return Condition.column(this.nameAlias).is((Object)value);
    }

    public Condition eq(double value) {
        return Condition.column(this.nameAlias).eq((Object)value);
    }

    public Condition isNot(double value) {
        return Condition.column(this.nameAlias).isNot((Object)value);
    }

    public Condition notEq(double value) {
        return Condition.column(this.nameAlias).notEq((Object)value);
    }

    public Condition like(double value) {
        return Condition.column(this.nameAlias).like(String.valueOf(value));
    }

    public Condition notLike(double value) {
        return Condition.column(this.nameAlias).notLike(String.valueOf(value));
    }

    public Condition glob(double value) {
        return Condition.column(this.nameAlias).glob(String.valueOf(value));
    }

    public Condition greaterThan(double value) {
        return Condition.column(this.nameAlias).greaterThan((Object)value);
    }

    public Condition greaterThanOrEq(double value) {
        return Condition.column(this.nameAlias).greaterThanOrEq((Object)value);
    }

    public Condition lessThan(double value) {
        return Condition.column(this.nameAlias).lessThan((Object)value);
    }

    public Condition lessThanOrEq(double value) {
        return Condition.column(this.nameAlias).lessThanOrEq((Object)value);
    }

    public Condition.Between between(double value) {
        return Condition.column(this.nameAlias).between((Object)value);
    }

    public Condition.In in(double firstValue, double ... values) {
        Condition.In in = Condition.column(this.nameAlias).in((Object)firstValue, new Object[0]);
        for (double value : values) {
            in.and(value);
        }
        return in;
    }

    public Condition.In notIn(double firstValue, double ... values) {
        Condition.In in = Condition.column(this.nameAlias).notIn((Object)firstValue, new Object[0]);
        for (double value : values) {
            in.and(value);
        }
        return in;
    }

    public Condition concatenate(double value) {
        return Condition.column(this.nameAlias).concatenate((Object)value);
    }

    public Condition is(DoubleProperty property) {
        return Condition.column(this.nameAlias).is(property);
    }

    public Condition isNot(DoubleProperty property) {
        return Condition.column(this.nameAlias).isNot(property);
    }

    public Condition eq(DoubleProperty property) {
        return this.is(property);
    }

    public Condition notEq(DoubleProperty property) {
        return this.isNot(property);
    }

    public Condition greaterThan(DoubleProperty property) {
        return Condition.column(this.nameAlias).greaterThan(property);
    }

    public Condition greaterThanOrEq(DoubleProperty property) {
        return Condition.column(this.nameAlias).greaterThanOrEq(property);
    }

    public Condition lessThan(DoubleProperty property) {
        return Condition.column(this.nameAlias).lessThan(property);
    }

    public Condition lessThanOrEq(DoubleProperty property) {
        return Condition.column(this.nameAlias).lessThanOrEq(property);
    }
}

