/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.From;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.PropertyFactory;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Join<TModel, TFromModel>
implements Query {
    private Class<TModel> table;
    private JoinType type;
    private From<TFromModel> from;
    private NameAlias alias;
    private ConditionGroup onGroup;
    private List<IProperty> using = new ArrayList<IProperty>();
    private boolean isNatural = false;

    Join(From<TFromModel> from, Class<TModel> table, @NonNull JoinType joinType) {
        this.from = from;
        this.table = table;
        this.type = joinType;
        this.alias = new NameAlias.Builder(FlowManager.getTableName(table)).build();
    }

    Join(From<TFromModel> from, @NonNull JoinType joinType, ModelQueriable<TModel> modelQueriable) {
        this.from = from;
        this.type = joinType;
        this.table = modelQueriable.getTable();
        this.alias = PropertyFactory.from(modelQueriable).getNameAlias();
    }

    public Join<TModel, TFromModel> as(String alias) {
        this.alias = this.alias.newBuilder().as(alias).build();
        return this;
    }

    public From<TFromModel> natural() {
        this.isNatural = true;
        return this.from;
    }

    public From<TFromModel> on(SQLCondition ... onConditions) {
        this.onGroup = new ConditionGroup();
        this.onGroup.andAll(onConditions);
        return this.from;
    }

    public From<TFromModel> using(IProperty ... columns) {
        Collections.addAll(this.using, columns);
        return this.from;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder();
        if (this.isNatural) {
            queryBuilder.append((Object)"NATURAL ");
        }
        queryBuilder.append((Object)this.type.name().replace("_", " ")).appendSpace();
        queryBuilder.append((Object)"JOIN").appendSpace().append((Object)this.alias.getFullQuery()).appendSpace();
        if (this.onGroup != null) {
            queryBuilder.append((Object)"ON").appendSpace().append((Object)this.onGroup.getQuery()).appendSpace();
        } else if (!this.using.isEmpty()) {
            queryBuilder.append((Object)"USING (").appendArray(new Object[]{this.using}).append((Object)")").appendSpace();
        }
        return queryBuilder.getQuery();
    }

    public static enum JoinType {
        LEFT_OUTER,
        INNER,
        CROSS;

    }
}

