/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure;

import android.database.Cursor;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.saveable.ListModelSaver;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import com.raizlabs.android.dbflow.structure.InternalAdapter;
import com.raizlabs.android.dbflow.structure.InvalidDBConfiguration;
import com.raizlabs.android.dbflow.structure.cache.IMultiKeyCacheConverter;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;
import com.raizlabs.android.dbflow.structure.cache.SimpleMapCache;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Collection;

public abstract class ModelAdapter<TModel>
extends InstanceAdapter<TModel>
implements InternalAdapter<TModel> {
    private DatabaseStatement insertStatement;
    private DatabaseStatement compiledStatement;
    private String[] cachingColumns;
    private ModelCache<TModel, ?> modelCache;
    private ModelSaver<TModel> modelSaver;
    private ListModelSaver<TModel> listModelSaver;

    public ModelAdapter(DatabaseDefinition databaseDefinition) {
        super(databaseDefinition);
        if (this.getTableConfig() != null && this.getTableConfig().modelSaver() != null) {
            this.modelSaver = this.getTableConfig().modelSaver();
            this.modelSaver.setModelAdapter(this);
        }
    }

    public DatabaseStatement getInsertStatement() {
        if (this.insertStatement == null) {
            this.insertStatement = this.getInsertStatement(FlowManager.getDatabaseForTable(this.getModelClass()).getWritableDatabase());
        }
        return this.insertStatement;
    }

    public DatabaseStatement getInsertStatement(DatabaseWrapper databaseWrapper) {
        return databaseWrapper.compileStatement(this.getInsertStatementQuery());
    }

    public DatabaseStatement getCompiledStatement() {
        if (this.compiledStatement == null) {
            this.compiledStatement = this.getCompiledStatement(FlowManager.getDatabaseForTable(this.getModelClass()).getWritableDatabase());
        }
        return this.compiledStatement;
    }

    public DatabaseStatement getCompiledStatement(DatabaseWrapper databaseWrapper) {
        return databaseWrapper.compileStatement(this.getCompiledStatementQuery());
    }

    public TModel loadFromCursor(Cursor cursor) {
        Object model = this.newInstance();
        this.loadFromCursor(cursor, model);
        return model;
    }

    @Override
    public void save(TModel model) {
        this.getModelSaver().save(model);
    }

    @Override
    public void save(TModel model, DatabaseWrapper databaseWrapper) {
        this.getModelSaver().save(model, databaseWrapper);
    }

    @Override
    public void saveAll(Collection<TModel> models) {
        this.getListModelSaver().saveAll(models);
        if (this.cachingEnabled()) {
            for (TModel model : models) {
                this.getModelCache().addModel(this.getCachingId(model), model);
            }
        }
    }

    @Override
    public void saveAll(Collection<TModel> models, DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().saveAll(models, databaseWrapper);
    }

    @Override
    public long insert(TModel model) {
        return this.getModelSaver().insert(model);
    }

    @Override
    public long insert(TModel model, DatabaseWrapper databaseWrapper) {
        return this.getModelSaver().insert(model, databaseWrapper);
    }

    @Override
    public void insertAll(Collection<TModel> models) {
        this.getListModelSaver().insertAll(models);
    }

    @Override
    public void insertAll(Collection<TModel> models, DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().insertAll(models, databaseWrapper);
    }

    @Override
    public void update(TModel model) {
        this.getModelSaver().update(model);
    }

    @Override
    public void update(TModel model, DatabaseWrapper databaseWrapper) {
        this.getModelSaver().update(model, databaseWrapper);
    }

    @Override
    public void updateAll(Collection<TModel> models) {
        this.getListModelSaver().updateAll(models);
    }

    @Override
    public void updateAll(Collection<TModel> models, DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().updateAll(models, databaseWrapper);
    }

    @Override
    public void delete(TModel model) {
        this.getModelSaver().delete(model);
    }

    @Override
    public void delete(TModel model, DatabaseWrapper databaseWrapper) {
        this.getModelSaver().delete(model, databaseWrapper);
    }

    @Override
    public void deleteAll(Collection<TModel> tModels, DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().deleteAll(tModels, databaseWrapper);
    }

    @Override
    public void deleteAll(Collection<TModel> tModels) {
        this.getListModelSaver().deleteAll(tModels);
    }

    @Override
    public void bindToInsertStatement(DatabaseStatement sqLiteStatement, TModel model) {
        this.bindToInsertStatement(sqLiteStatement, model, 0);
    }

    @Override
    public void updateAutoIncrement(TModel model, Number id) {
    }

    @Override
    public Number getAutoIncrementingId(TModel model) {
        throw new InvalidDBConfiguration(String.format("This method may have been called in error. The model class %1s must containa single primary key (if used in a ModelCache, this method may be called)", this.getModelClass()));
    }

    public String getAutoIncrementingColumnName() {
        throw new InvalidDBConfiguration(String.format("This method may have been called in error. The model class %1s must contain an autoincrementing or single int/long primary key (if used in a ModelCache, this method may be called)", this.getModelClass()));
    }

    public void saveForeignKeys(TModel model, DatabaseWrapper wrapper) {
    }

    public void deleteForeignKeys(TModel model, DatabaseWrapper wrapper) {
    }

    public String[] createCachingColumns() {
        return new String[]{this.getAutoIncrementingColumnName()};
    }

    public String[] getCachingColumns() {
        if (this.cachingColumns == null) {
            this.cachingColumns = this.createCachingColumns();
        }
        return this.cachingColumns;
    }

    public Object[] getCachingColumnValuesFromCursor(Object[] inValues, Cursor cursor) {
        this.throwCachingError();
        return null;
    }

    public Object getCachingColumnValueFromCursor(Cursor cursor) {
        this.throwSingleCachingError();
        return null;
    }

    public Object[] getCachingColumnValuesFromModel(Object[] inValues, TModel TModel) {
        this.throwCachingError();
        return null;
    }

    public Object getCachingColumnValueFromModel(TModel model) {
        this.throwSingleCachingError();
        return null;
    }

    public void storeModelInCache(@NonNull TModel model) {
        this.getModelCache().addModel(this.getCachingId(model), model);
    }

    public ModelCache<TModel, ?> getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = this.createModelCache();
        }
        return this.modelCache;
    }

    public Object getCachingId(@NonNull Object[] inValues) {
        if (inValues.length == 1) {
            return inValues[0];
        }
        return this.getCacheConverter().getCachingKey(inValues);
    }

    public Object getCachingId(@NonNull TModel model) {
        return this.getCachingId(this.getCachingColumnValuesFromModel(new Object[this.getCachingColumns().length], model));
    }

    public ModelSaver<TModel> getModelSaver() {
        if (this.modelSaver == null) {
            this.modelSaver = new ModelSaver();
            this.modelSaver.setModelAdapter(this);
        }
        return this.modelSaver;
    }

    public ListModelSaver<TModel> getListModelSaver() {
        if (this.listModelSaver == null) {
            this.listModelSaver = this.createListModelSaver();
        }
        return this.listModelSaver;
    }

    protected ListModelSaver<TModel> createListModelSaver() {
        return new ListModelSaver<TModel>(this.getModelSaver());
    }

    public void setModelSaver(ModelSaver<TModel> modelSaver) {
        this.modelSaver = modelSaver;
    }

    public void reloadRelationships(@NonNull TModel model, Cursor cursor) {
        this.throwCachingError();
    }

    @Override
    public boolean cachingEnabled() {
        return false;
    }

    public int getCacheSize() {
        return 25;
    }

    public IMultiKeyCacheConverter<?> getCacheConverter() {
        throw new InvalidDBConfiguration("For multiple primary keys, a public static IMultiKeyCacheConverter field mustbe  marked with @MultiCacheField in the corresponding model class. The resulting keymust be a unique combination of the multiple keys, otherwise inconsistencies may occur.");
    }

    public ModelCache<TModel, ?> createModelCache() {
        return new SimpleMapCache(this.getCacheSize());
    }

    public abstract String getCreationQuery();

    public abstract BaseProperty getProperty(String var1);

    public abstract IProperty[] getAllColumnProperties();

    protected abstract String getInsertStatementQuery();

    protected abstract String getCompiledStatementQuery();

    public ConflictAction getUpdateOnConflictAction() {
        return ConflictAction.ABORT;
    }

    public ConflictAction getInsertOnConflictAction() {
        return ConflictAction.ABORT;
    }

    private void throwCachingError() {
        throw new InvalidDBConfiguration(String.format("This method may have been called in error. The model class %1s must containan auto-incrementing or at least one primary key (if used in a ModelCache, this method may be called)", this.getModelClass()));
    }

    private void throwSingleCachingError() {
        throw new InvalidDBConfiguration(String.format("This method may have been called in error. The model class %1s must containan auto-incrementing or one primary key (if used in a ModelCache, this method may be called)", this.getModelClass()));
    }
}

