/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class IntProperty
extends BaseProperty<IntProperty> {
    public IntProperty(Class<?> table, NameAlias nameAlias) {
        super(table, nameAlias);
    }

    public IntProperty(Class<?> table, String columnName) {
        this(table, new NameAlias.Builder(columnName).build());
    }

    public IntProperty(Class<?> table, String columnName, String aliasName) {
        this(table, new NameAlias.Builder(columnName).as(aliasName).build());
    }

    @Override
    public IntProperty plus(IProperty iProperty) {
        return new IntProperty(this.table, NameAlias.joinNames("+", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public IntProperty minus(IProperty iProperty) {
        return new IntProperty(this.table, NameAlias.joinNames("-", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public IntProperty dividedBy(IProperty iProperty) {
        return new IntProperty(this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public IntProperty multipliedBy(IProperty iProperty) {
        return new IntProperty(this.table, NameAlias.joinNames("*", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public IntProperty mod(IProperty iProperty) {
        return new IntProperty(this.table, NameAlias.joinNames("%", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public IntProperty concatenate(IProperty iProperty) {
        return new IntProperty(this.table, NameAlias.joinNames("||", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public IntProperty as(String aliasName) {
        return new IntProperty(this.table, this.nameAlias.newBuilder().as(aliasName).build());
    }

    @Override
    public IntProperty distinct() {
        return new IntProperty(this.table, this.getDistinctAliasName());
    }

    @Override
    public IntProperty withTable(NameAlias tableNameAlias) {
        return new IntProperty(this.table, this.nameAlias.newBuilder().withTable(tableNameAlias.getQuery()).build());
    }

    public Condition is(int value) {
        return Condition.column(this.nameAlias).is((Object)value);
    }

    public Condition eq(int value) {
        return Condition.column(this.nameAlias).eq((Object)value);
    }

    public Condition isNot(int value) {
        return Condition.column(this.nameAlias).isNot((Object)value);
    }

    public Condition notEq(int value) {
        return Condition.column(this.nameAlias).notEq((Object)value);
    }

    public Condition like(int value) {
        return Condition.column(this.nameAlias).like(String.valueOf(value));
    }

    public Condition notLike(int value) {
        return Condition.column(this.nameAlias).notLike(String.valueOf(value));
    }

    public Condition glob(int value) {
        return Condition.column(this.nameAlias).glob(String.valueOf(value));
    }

    public Condition greaterThan(int value) {
        return Condition.column(this.nameAlias).greaterThan((Object)value);
    }

    public Condition greaterThanOrEq(int value) {
        return Condition.column(this.nameAlias).greaterThanOrEq((Object)value);
    }

    public Condition lessThan(int value) {
        return Condition.column(this.nameAlias).lessThan((Object)value);
    }

    public Condition lessThanOrEq(int value) {
        return Condition.column(this.nameAlias).lessThanOrEq((Object)value);
    }

    public Condition.Between between(int value) {
        return Condition.column(this.nameAlias).between((Object)value);
    }

    public Condition.In in(int firstValue, int ... values) {
        Condition.In in = Condition.column(this.nameAlias).in((Object)firstValue, new Object[0]);
        for (int value : values) {
            in.and(value);
        }
        return in;
    }

    public Condition.In notIn(int firstValue, int ... values) {
        Condition.In in = Condition.column(this.nameAlias).notIn((Object)firstValue, new Object[0]);
        for (int value : values) {
            in.and(value);
        }
        return in;
    }

    public Condition concatenate(int value) {
        return Condition.column(this.nameAlias).concatenate((Object)value);
    }

    public Condition is(IntProperty property) {
        return Condition.column(this.nameAlias).is(property);
    }

    public Condition isNot(IntProperty property) {
        return Condition.column(this.nameAlias).isNot(property);
    }

    public Condition eq(IntProperty property) {
        return this.is(property);
    }

    public Condition notEq(IntProperty property) {
        return this.isNot(property);
    }

    public Condition greaterThan(IntProperty property) {
        return Condition.column(this.nameAlias).greaterThan(property);
    }

    public Condition greaterThanOrEq(IntProperty property) {
        return Condition.column(this.nameAlias).greaterThanOrEq(property);
    }

    public Condition lessThan(IntProperty property) {
        return Condition.column(this.nameAlias).lessThan(property);
    }

    public Condition lessThanOrEq(IntProperty property) {
        return Condition.column(this.nameAlias).lessThanOrEq(property);
    }
}

