/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import com.raizlabs.android.dbflow.annotation.Collate;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.converter.TypeConverter;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseCondition;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.IConditional;
import com.raizlabs.android.dbflow.sql.language.ITypeConditional;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Condition
extends BaseCondition
implements ITypeConditional {
    private TypeConverter typeConverter;
    private boolean convertToDB;

    public static String convertValueToString(Object value) {
        return BaseCondition.convertValueToString(value, false);
    }

    public static Condition column(NameAlias column) {
        return new Condition(column);
    }

    public static Condition column(NameAlias alias, TypeConverter typeConverter, boolean convertToDB) {
        return new Condition(alias, typeConverter, convertToDB);
    }

    Condition(NameAlias nameAlias) {
        super(nameAlias);
    }

    Condition(NameAlias alias, TypeConverter typeConverter, boolean convertToDB) {
        super(alias);
        this.typeConverter = typeConverter;
        this.convertToDB = convertToDB;
    }

    @Override
    public void appendConditionToQuery(QueryBuilder queryBuilder) {
        queryBuilder.append((Object)this.columnName()).append((Object)this.operation());
        if (this.isValueSet) {
            queryBuilder.append((Object)this.convertObjectToString(this.value(), true));
        }
        if (this.postArgument() != null) {
            queryBuilder.appendSpace().append((Object)this.postArgument());
        }
    }

    public Condition is(Object value) {
        this.operation = "=";
        return this.value(value);
    }

    public Condition eq(Object value) {
        return this.is(value);
    }

    public Condition isNot(Object value) {
        this.operation = "!=";
        return this.value(value);
    }

    public Condition notEq(Object value) {
        return this.isNot(value);
    }

    @Override
    public Condition like(String value) {
        this.operation = String.format(" %1s ", "LIKE");
        return this.value(value);
    }

    @Override
    public Condition notLike(String value) {
        this.operation = String.format(" %1s ", "NOT LIKE");
        return this.value(value);
    }

    @Override
    public Condition glob(String value) {
        this.operation = String.format(" %1s ", "GLOB");
        return this.value(value);
    }

    public Condition value(Object value) {
        this.value = value;
        this.isValueSet = true;
        return this;
    }

    public Condition greaterThan(Object value) {
        this.operation = ">";
        return this.value(value);
    }

    public Condition greaterThanOrEq(Object value) {
        this.operation = ">=";
        return this.value(value);
    }

    public Condition lessThan(Object value) {
        this.operation = "<";
        return this.value(value);
    }

    public Condition lessThanOrEq(Object value) {
        this.operation = "<=";
        return this.value(value);
    }

    public Condition operation(String operation) {
        this.operation = operation;
        return this;
    }

    public Condition collate(String collation) {
        this.postArg = "COLLATE " + collation;
        return this;
    }

    public Condition collate(Collate collation) {
        if (collation.equals((Object)Collate.NONE)) {
            this.postArg = null;
        } else {
            this.collate(collation.name());
        }
        return this;
    }

    public Condition postfix(String postfix) {
        this.postArg = postfix;
        return this;
    }

    @Override
    public Condition isNull() {
        this.operation = String.format(" %1s ", "IS NULL");
        return this;
    }

    @Override
    public Condition isNotNull() {
        this.operation = String.format(" %1s ", "IS NOT NULL");
        return this;
    }

    @Override
    public Condition separator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public Condition is(IConditional conditional) {
        return this.is((Object)conditional);
    }

    @Override
    public Condition eq(IConditional conditional) {
        return this.eq((Object)conditional);
    }

    @Override
    public Condition isNot(IConditional conditional) {
        return this.isNot((Object)conditional);
    }

    @Override
    public Condition notEq(IConditional conditional) {
        return this.notEq((Object)conditional);
    }

    @Override
    public Condition like(IConditional conditional) {
        return this.like(conditional.getQuery());
    }

    @Override
    public Condition glob(IConditional conditional) {
        return this.glob(conditional.getQuery());
    }

    @Override
    public Condition greaterThan(IConditional conditional) {
        return this.greaterThan((Object)conditional);
    }

    @Override
    public Condition greaterThanOrEq(IConditional conditional) {
        return this.greaterThanOrEq((Object)conditional);
    }

    @Override
    public Condition lessThan(IConditional conditional) {
        return this.lessThan((Object)conditional);
    }

    @Override
    public Condition lessThanOrEq(IConditional conditional) {
        return this.lessThanOrEq((Object)conditional);
    }

    @Override
    public Between between(IConditional conditional) {
        return this.between((Object)conditional);
    }

    @Override
    public In in(IConditional firstConditional, IConditional ... conditionals) {
        return this.in((Object)firstConditional, (Object[])conditionals);
    }

    @Override
    public In notIn(IConditional firstConditional, IConditional ... conditionals) {
        return this.notIn((Object)firstConditional, (Object[])conditionals);
    }

    @Override
    public In notIn(BaseModelQueriable firstBaseModelQueriable, BaseModelQueriable[] baseModelQueriables) {
        return this.notIn((Object)firstBaseModelQueriable, (Object[])baseModelQueriables);
    }

    @Override
    public Condition is(BaseModelQueriable baseModelQueriable) {
        return this.is((Object)baseModelQueriable);
    }

    @Override
    public Condition eq(BaseModelQueriable baseModelQueriable) {
        return this.eq((Object)baseModelQueriable);
    }

    @Override
    public Condition isNot(BaseModelQueriable baseModelQueriable) {
        return this.isNot((Object)baseModelQueriable);
    }

    @Override
    public Condition notEq(BaseModelQueriable baseModelQueriable) {
        return this.notEq((Object)baseModelQueriable);
    }

    @Override
    public Condition like(BaseModelQueriable baseModelQueriable) {
        return this.like(baseModelQueriable.getQuery());
    }

    @Override
    public Condition glob(BaseModelQueriable baseModelQueriable) {
        return this.glob(baseModelQueriable.getQuery());
    }

    @Override
    public Condition greaterThan(BaseModelQueriable baseModelQueriable) {
        return this.greaterThan((Object)baseModelQueriable);
    }

    @Override
    public Condition greaterThanOrEq(BaseModelQueriable baseModelQueriable) {
        return this.greaterThanOrEq((Object)baseModelQueriable);
    }

    @Override
    public Condition lessThan(BaseModelQueriable baseModelQueriable) {
        return this.lessThan((Object)baseModelQueriable);
    }

    @Override
    public Condition lessThanOrEq(BaseModelQueriable baseModelQueriable) {
        return this.lessThanOrEq((Object)baseModelQueriable);
    }

    @Override
    public Between between(BaseModelQueriable baseModelQueriable) {
        return this.between((Object)baseModelQueriable);
    }

    @Override
    public In in(BaseModelQueriable firstBaseModelQueriable, BaseModelQueriable ... baseModelQueriables) {
        return this.in((Object)firstBaseModelQueriable, (Object[])baseModelQueriables);
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder();
        this.appendConditionToQuery(queryBuilder);
        return queryBuilder.getQuery();
    }

    public Condition concatenate(Object value) {
        TypeConverter typeConverter;
        this.operation = new QueryBuilder((Object)"=").append((Object)this.columnName()).toString();
        if (value != null && (typeConverter = FlowManager.getTypeConverterForClass(value.getClass())) != null) {
            value = typeConverter.getDBValue(value);
        }
        if (value instanceof String || value instanceof ITypeConditional) {
            this.operation = String.format("%1s %1s ", this.operation, "||");
        } else if (value instanceof Number) {
            this.operation = String.format("%1s %1s ", this.operation, "+");
        } else {
            throw new IllegalArgumentException(String.format("Cannot concatenate the %1s", value != null ? value.getClass() : "null"));
        }
        this.value = value;
        this.isValueSet = true;
        return this;
    }

    @Override
    public Condition concatenate(IConditional conditional) {
        return this.concatenate((Object)conditional);
    }

    public Between between(Object value) {
        return new Between(this, value);
    }

    public In in(Object firstArgument, Object ... arguments) {
        return new In(this, firstArgument, true, arguments);
    }

    public In notIn(Object firstArgument, Object ... arguments) {
        return new In(this, firstArgument, false, arguments);
    }

    public In in(Collection values) {
        return new In(this, values, true);
    }

    public In notIn(Collection values) {
        return new In(this, values, false);
    }

    @Override
    public String convertObjectToString(Object object, boolean appendInnerParenthesis) {
        if (this.typeConverter != null) {
            Object converted = this.convertToDB ? this.typeConverter.getDBValue(object) : object;
            return BaseCondition.convertValueToString(converted, appendInnerParenthesis, false);
        }
        return super.convertObjectToString(object, appendInnerParenthesis);
    }

    public static class In
    extends BaseCondition {
        private List<Object> inArguments = new ArrayList<Object>();

        private In(Condition condition, Object firstArgument, boolean isIn, Object ... arguments) {
            super(condition.columnAlias());
            this.inArguments.add(firstArgument);
            Collections.addAll(this.inArguments, arguments);
            this.operation = String.format(" %1s ", isIn ? "IN" : "NOT IN");
        }

        private In(Condition condition, Collection<Object> args, boolean isIn) {
            super(condition.columnAlias());
            this.inArguments.addAll(args);
            this.operation = String.format(" %1s ", isIn ? "IN" : "NOT IN");
        }

        public In and(Object argument) {
            this.inArguments.add(argument);
            return this;
        }

        @Override
        public void appendConditionToQuery(QueryBuilder queryBuilder) {
            queryBuilder.append((Object)this.columnName()).append((Object)this.operation()).append((Object)"(").append((Object)ConditionGroup.joinArguments(",", this.inArguments, this)).append((Object)")");
        }
    }

    public static class Between
    extends BaseCondition {
        private Object secondValue;

        private Between(Condition condition, Object value) {
            super(condition.nameAlias);
            this.operation = String.format(" %1s ", "BETWEEN");
            this.value = value;
            this.isValueSet = true;
            this.postArg = condition.postArgument();
        }

        public Between and(Object secondValue) {
            this.secondValue = secondValue;
            return this;
        }

        public Object secondValue() {
            return this.secondValue;
        }

        @Override
        public void appendConditionToQuery(QueryBuilder queryBuilder) {
            queryBuilder.append((Object)this.columnName()).append((Object)this.operation()).append((Object)this.convertObjectToString(this.value(), true)).appendSpaceSeparated((Object)"AND").append((Object)this.convertObjectToString(this.secondValue(), true)).appendSpace().appendOptional((Object)this.postArgument());
        }
    }

    public static class Operation {
        public static final String EQUALS = "=";
        public static final String NOT_EQUALS = "!=";
        public static final String CONCATENATE = "||";
        public static final String PLUS = "+";
        public static final String MINUS = "-";
        public static final String DIVISION = "/";
        public static final String MULTIPLY = "*";
        public static final String MOD = "%";
        public static final String LIKE = "LIKE";
        public static final String NOT_LIKE = "NOT LIKE";
        public static final String GLOB = "GLOB";
        public static final String GREATER_THAN = ">";
        public static final String GREATER_THAN_OR_EQUALS = ">=";
        public static final String LESS_THAN = "<";
        public static final String LESS_THAN_OR_EQUALS = "<=";
        public static final String BETWEEN = "BETWEEN";
        public static final String AND = "AND";
        public static final String OR = "OR";
        public static final String EMPTY_PARAM = "?";
        public static final String IS_NOT_NULL = "IS NOT NULL";
        public static final String IS_NULL = "IS NULL";
        public static final String IN = "IN";
        public static final String NOT_IN = "NOT IN";
    }
}

