/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseCondition;
import com.raizlabs.android.dbflow.sql.language.CaseCondition;
import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.util.ArrayList;
import java.util.List;

public class Case<TReturn>
implements Query {
    private IProperty caseColumn;
    private List<CaseCondition<TReturn>> caseConditions = new ArrayList<CaseCondition<TReturn>>();
    private String columnName;
    private TReturn elseValue;
    private boolean elseSpecified = false;
    private boolean efficientCase = false;
    private boolean endSpecified = false;

    Case() {
    }

    Case(IProperty caseColumn) {
        this.caseColumn = caseColumn;
        this.efficientCase = true;
    }

    public CaseCondition<TReturn> when(SQLCondition sqlCondition) {
        if (this.efficientCase) {
            throw new IllegalStateException("When using the efficient CASE method,you must pass in value only, not condition.");
        }
        CaseCondition<SQLCondition> caseCondition = new CaseCondition<SQLCondition>((Case<SQLCondition>)this, sqlCondition);
        this.caseConditions.add(caseCondition);
        return caseCondition;
    }

    public CaseCondition<TReturn> when(TReturn whenValue) {
        if (!this.efficientCase) {
            throw new IllegalStateException("When not using the efficient CASE method, you must pass in the SQLConditions as a parameter");
        }
        CaseCondition<TReturn> caseCondition = new CaseCondition<TReturn>(this, whenValue);
        this.caseConditions.add(caseCondition);
        return caseCondition;
    }

    public CaseCondition<TReturn> when(IProperty property) {
        if (!this.efficientCase) {
            throw new IllegalStateException("When not using the efficient CASE method, you must pass in the SQLCondition as a parameter");
        }
        CaseCondition caseCondition = new CaseCondition(this, property);
        this.caseConditions.add(caseCondition);
        return caseCondition;
    }

    public Case<TReturn> _else(TReturn elseValue) {
        this.elseValue = elseValue;
        this.elseSpecified = true;
        return this;
    }

    public Property<Case<TReturn>> end(@Nullable String columnName) {
        this.endSpecified = true;
        if (columnName != null) {
            this.columnName = QueryBuilder.quoteIfNeeded((String)columnName);
        }
        return new Property<Case<TReturn>>(null, NameAlias.rawBuilder(this.getQuery()).build());
    }

    public Property<Case<TReturn>> end() {
        return this.end(null);
    }

    public Condition endAsCondition() {
        return Condition.column(this.end().getNameAlias());
    }

    boolean isEfficientCase() {
        return this.efficientCase;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)" CASE");
        if (this.isEfficientCase()) {
            queryBuilder.append((Object)(" " + BaseCondition.convertValueToString(this.caseColumn, false)));
        }
        queryBuilder.append((Object)QueryBuilder.join((CharSequence)" ", this.caseConditions));
        if (this.elseSpecified) {
            queryBuilder.append((Object)" ELSE ").append((Object)BaseCondition.convertValueToString(this.elseValue, false));
        }
        if (this.endSpecified) {
            queryBuilder.append((Object)(" END " + (this.columnName != null ? this.columnName : "")));
        }
        return queryBuilder.getQuery();
    }
}

