/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.rx2.language;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.runtime.OnTableChangedListener;
import com.raizlabs.android.dbflow.runtime.TableNotifierRegister;
import com.raizlabs.android.dbflow.sql.language.From;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.BaseModel;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.disposables.Disposables;
import java.util.Set;

public class TableChangeOnSubscribe<TModel>
implements FlowableOnSubscribe<ModelQueriable<TModel>> {
    private final ModelQueriable<TModel> modelQueriable;
    private final TableNotifierRegister register;
    private FlowableEmitter<ModelQueriable<TModel>> flowableEmitter;
    private final OnTableChangedListener onTableChangedListener = new OnTableChangedListener(){

        public void onTableChanged(@Nullable Class<?> tableChanged, @NonNull BaseModel.Action action) {
            if (TableChangeOnSubscribe.this.modelQueriable.getTable().equals(tableChanged)) {
                TableChangeOnSubscribe.this.flowableEmitter.onNext((Object)TableChangeOnSubscribe.this.modelQueriable);
            }
        }
    };

    public TableChangeOnSubscribe(ModelQueriable<TModel> modelQueriable) {
        this.modelQueriable = modelQueriable;
        this.register = FlowManager.newRegisterForTable((Class)modelQueriable.getTable());
    }

    public void subscribe(FlowableEmitter<ModelQueriable<TModel>> e) throws Exception {
        this.flowableEmitter = e;
        this.flowableEmitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

            @Override
            public void run() {
                TableChangeOnSubscribe.this.register.unregisterAll();
            }
        }));
        From from = null;
        if (this.modelQueriable instanceof From) {
            from = (From)this.modelQueriable;
        } else if (this.modelQueriable instanceof Where && ((Where)this.modelQueriable).getWhereBase() instanceof From) {
            from = (From)((Where)this.modelQueriable).getWhereBase();
        }
        if (from != null) {
            Set associatedTables = from.getAssociatedTables();
            for (Class table : associatedTables) {
                this.register.register(table);
            }
        } else {
            this.register.register(this.modelQueriable.getTable());
        }
        this.register.setListener(this.onTableChangedListener);
        this.flowableEmitter.onNext(this.modelQueriable);
    }
}

