/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor;

import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.processor.ProcessorManager;
import com.raizlabs.android.dbflow.processor.Validator;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnAccessor;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.EnumColumnAccessor;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.PrivateScopeColumnAccessor;
import com.raizlabs.android.dbflow.processor.utils.StringUtilsKt;
import com.squareup.javapoet.TypeName;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/raizlabs/android/dbflow/processor/ColumnValidator;", "Lcom/raizlabs/android/dbflow/processor/Validator;", "Lcom/raizlabs/android/dbflow/processor/definition/column/ColumnDefinition;", "()V", "autoIncrementingPrimaryKey", "validate", "", "processorManager", "Lcom/raizlabs/android/dbflow/processor/ProcessorManager;", "validatorDefinition", "dbflow-processor_main"})
public final class ColumnValidator
implements Validator<ColumnDefinition> {
    private ColumnDefinition autoIncrementingPrimaryKey;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean validate(@NotNull ProcessorManager processorManager, @NotNull ColumnDefinition validatorDefinition) {
        void success;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)processorManager, (String)"processorManager");
        Intrinsics.checkParameterIsNotNull((Object)validatorDefinition, (String)"validatorDefinition");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        if (validatorDefinition.getColumnAccessor() instanceof PrivateScopeColumnAccessor) {
            ColumnAccessor columnAccessor = validatorDefinition.getColumnAccessor();
            if (columnAccessor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.raizlabs.android.dbflow.processor.definition.column.PrivateScopeColumnAccessor");
            }
            PrivateScopeColumnAccessor privateColumnAccess = (PrivateScopeColumnAccessor)columnAccessor;
            if (!validatorDefinition.getBaseTableDefinition().getClassElementLookUpMap().containsKey(privateColumnAccess.getGetterNameElement())) {
                processorManager.logError(Reflection.getOrCreateKotlinClass(ColumnValidator.class), "Could not find getter for private element: \"%1s\" from table class: %1s. Consider adding a getter with name %1s or making it more accessible.", validatorDefinition.getElementName(), validatorDefinition.getBaseTableDefinition().getElementName(), privateColumnAccess.getGetterNameElement());
                success.element = false;
            }
            if (!validatorDefinition.getBaseTableDefinition().getClassElementLookUpMap().containsKey(privateColumnAccess.getSetterNameElement())) {
                processorManager.logError(Reflection.getOrCreateKotlinClass(ColumnValidator.class), "Could not find setter for private element: " + "\"" + validatorDefinition.getElementName() + "\"" + (" from table class: " + validatorDefinition.getBaseTableDefinition().getElementName() + ". ") + ("Consider adding a setter with name " + privateColumnAccess.getSetterNameElement() + " or making it more accessible."), new Object[0]);
                success.element = false;
            }
        }
        if (!StringUtilsKt.isNullOrEmpty(validatorDefinition.getDefaultValue())) {
            TypeName typeName = validatorDefinition.getElementTypeName();
            if (validatorDefinition instanceof ForeignKeyColumnDefinition && ((ForeignKeyColumnDefinition)validatorDefinition).isReferencingTableObject()) {
                processorManager.logError(Reflection.getOrCreateKotlinClass(ColumnValidator.class), "Default values cannot be specified for model fields", new Object[0]);
            } else if (typeName != null && typeName.isPrimitive()) {
                processorManager.logWarning(ColumnValidator.class, "Primitive column types will not respect default values", new Object[0]);
            }
        }
        if ((charSequence = (CharSequence)validatorDefinition.getColumnName()).length() == 0) {
            success.element = false;
            processorManager.logError("Field %1s cannot have a null column name for column: %1s and type: %1s", validatorDefinition.getElementName(), validatorDefinition.getColumnName(), validatorDefinition.getElementTypeName());
        }
        if (validatorDefinition.getColumnAccessor() instanceof EnumColumnAccessor) {
            if (validatorDefinition.isPrimaryKey()) {
                success.element = false;
                processorManager.logError("Enums cannot be primary keys. Column: " + validatorDefinition.getColumnName() + (" and type: " + validatorDefinition.getElementTypeName()), new Object[0]);
            } else if (validatorDefinition instanceof ForeignKeyColumnDefinition) {
                success.element = false;
                processorManager.logError("Enums cannot be foreign keys. Column: " + validatorDefinition.getColumnName() + (" and type: " + validatorDefinition.getElementTypeName()), new Object[0]);
            }
        }
        if (validatorDefinition instanceof ForeignKeyColumnDefinition) {
            Column column = validatorDefinition.getColumn();
            if (column != null) {
                charSequence = column;
                CharSequence it = charSequence;
                CharSequence charSequence2 = it.name();
                if (charSequence2.length() > 0) {
                    success.element = false;
                    processorManager.logError("Foreign Key " + validatorDefinition.getElementName() + " cannot specify the column() field. " + "Use a @ForeignKeyReference(columnName = {NAME} instead. " + ("Column: " + validatorDefinition.getColumnName() + " and type: " + validatorDefinition.getElementTypeName()), new Object[0]);
                }
            }
        } else {
            if (this.autoIncrementingPrimaryKey != null && validatorDefinition.isPrimaryKey()) {
                processorManager.logError("You cannot mix and match autoincrementing and composite primary keys.", new Object[0]);
                success.element = false;
            }
            if (validatorDefinition.isPrimaryKeyAutoIncrement() || validatorDefinition.isRowId()) {
                if (this.autoIncrementingPrimaryKey == null) {
                    this.autoIncrementingPrimaryKey = validatorDefinition;
                } else if (Intrinsics.areEqual((Object)this.autoIncrementingPrimaryKey, (Object)validatorDefinition) ^ true) {
                    processorManager.logError("Only one auto-incrementing primary key is allowed on a table. " + ("Found Column: " + validatorDefinition.getColumnName() + " and type: " + validatorDefinition.getElementTypeName()), new Object[0]);
                    success.element = false;
                }
            }
        }
        return success.element;
    }
}

