/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.handler;

import com.google.common.collect.Sets;
import com.raizlabs.android.dbflow.processor.handler.Handler;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;

public abstract class BaseContainerHandler<AnnotationClass extends Annotation>
implements Handler {
    @Override
    public void handle(ProcessorManager processorManager, RoundEnvironment roundEnvironment) {
        HashSet annotatedElements = Sets.newHashSet(roundEnvironment.getElementsAnnotatedWith(this.getAnnotationClass()));
        this.processElements(processorManager, annotatedElements);
        if (annotatedElements.size() > 0) {
            for (Element element : annotatedElements) {
                this.onProcessElement(processorManager, element);
            }
        }
    }

    protected abstract Class<AnnotationClass> getAnnotationClass();

    public void processElements(ProcessorManager processorManager, Set<Element> annotatedElements) {
    }

    protected abstract void onProcessElement(ProcessorManager var1, Element var2);
}

