/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method.provider;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.ContentProviderDefinition;
import com.raizlabs.android.dbflow.processor.definition.ContentUriDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableEndpointDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.provider.ProviderMethodUtils;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class QueryMethod
implements MethodDefinition {
    private final ContentProviderDefinition contentProviderDefinition;
    private final ProcessorManager manager;

    public QueryMethod(ContentProviderDefinition contentProviderDefinition, ProcessorManager manager) {
        this.contentProviderDefinition = contentProviderDefinition;
        this.manager = manager;
    }

    @Override
    public MethodSpec getMethodSpec() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"query").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)ClassNames.URI, "uri", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of(String.class), "projection", new Modifier[0]).addParameter((TypeName)ClassName.get(String.class), "selection", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of(String.class), "selectionArgs", new Modifier[0]).addParameter((TypeName)ClassName.get(String.class), "sortOrder", new Modifier[0]).returns((TypeName)ClassNames.CURSOR);
        method.addStatement("$L cursor = null", new Object[]{ClassNames.CURSOR});
        method.beginControlFlow("switch($L.match(uri))", new Object[]{"MATCHER"});
        for (TableEndpointDefinition tableEndpointDefinition : this.contentProviderDefinition.endpointDefinitions) {
            for (ContentUriDefinition uriDefinition : tableEndpointDefinition.contentUriDefinitions) {
                if (!uriDefinition.queryEnabled) continue;
                method.beginControlFlow("case $L:", new Object[]{uriDefinition.name});
                method.addCode(ProviderMethodUtils.getSegmentsPreparation(uriDefinition));
                method.addCode("cursor = $T.getDatabase($S).getWritableDatabase().query($S, projection, ", new Object[]{ClassNames.FLOW_MANAGER, this.manager.getDatabaseName(this.contentProviderDefinition.databaseName), tableEndpointDefinition.tableName});
                method.addCode(ProviderMethodUtils.getSelectionAndSelectionArgs(uriDefinition));
                method.addCode(", null, null, sortOrder);\n", new Object[0]);
                method.addStatement("break", new Object[0]);
                method.endControlFlow();
            }
        }
        method.endControlFlow();
        method.beginControlFlow("if (cursor != null)", new Object[0]);
        method.addStatement("cursor.setNotificationUri(getContext().getContentResolver(), uri)", new Object[0]);
        method.endControlFlow();
        method.addStatement("return cursor", new Object[0]);
        return method.build();
    }
}

