/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method.provider;

import com.raizlabs.android.dbflow.annotation.provider.Notify;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.ContentProviderDefinition;
import com.raizlabs.android.dbflow.processor.definition.ContentUriDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableEndpointDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.provider.NotifyMethod;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class InsertMethod
implements MethodDefinition {
    private static final String PARAM_URI = "uri";
    private static final String PARAM_CONTENT_VALUES = "values";
    private final ContentProviderDefinition contentProviderDefinition;
    private final boolean isBulk;

    public InsertMethod(ContentProviderDefinition contentProviderDefinition, boolean isBulk) {
        this.contentProviderDefinition = contentProviderDefinition;
        this.isBulk = isBulk;
    }

    @Override
    public MethodSpec getMethodSpec() {
        CodeBlock.Builder code = CodeBlock.builder();
        code.beginControlFlow("switch(MATCHER.match($L))", new Object[]{PARAM_URI});
        for (TableEndpointDefinition tableEndpointDefinition : this.contentProviderDefinition.endpointDefinitions) {
            for (ContentUriDefinition uriDefinition : tableEndpointDefinition.contentUriDefinitions) {
                if (!uriDefinition.insertEnabled) continue;
                code.beginControlFlow("case $L:", new Object[]{uriDefinition.name});
                code.addStatement("$T adapter = $T.getModelAdapter($T.getTableClassForName($S, $S))", new Object[]{ClassNames.MODEL_ADAPTER, ClassNames.FLOW_MANAGER, ClassNames.FLOW_MANAGER, this.contentProviderDefinition.databaseNameString, tableEndpointDefinition.tableName});
                code.add("final long id = FlowManager.getDatabase($S).getWritableDatabase()", new Object[]{this.contentProviderDefinition.databaseNameString}).add(".insertWithOnConflict($S, null, values, $T.getSQLiteDatabaseAlgorithmInt(adapter.getInsertOnConflictAction()));\n", new Object[]{tableEndpointDefinition.tableName, ClassNames.CONFLICT_ACTION});
                new NotifyMethod(tableEndpointDefinition, uriDefinition, Notify.Method.INSERT).addCode(code);
                if (!this.isBulk) {
                    code.addStatement("return $T.withAppendedId($L, id)", new Object[]{ClassNames.CONTENT_URIS, PARAM_URI});
                } else {
                    code.addStatement("return id > 0 ? 1 : 0", new Object[0]);
                }
                code.endControlFlow();
            }
        }
        code.beginControlFlow("default:", new Object[0]).addStatement("throw new $T($S + $L)", new Object[]{ClassName.get(IllegalStateException.class), "Unknown Uri", PARAM_URI}).endControlFlow();
        code.endControlFlow();
        return MethodSpec.methodBuilder((String)(this.isBulk ? "bulkInsert" : "insert")).addAnnotation(Override.class).addParameter((TypeName)ClassNames.URI, PARAM_URI, new Modifier[0]).addParameter((TypeName)ClassNames.CONTENT_VALUES, PARAM_CONTENT_VALUES, new Modifier[0]).addModifiers(new Modifier[]{this.isBulk ? Modifier.PROTECTED : Modifier.PUBLIC, Modifier.FINAL}).addCode(code.build()).returns((TypeName)(this.isBulk ? TypeName.INT : ClassNames.URI)).build();
    }
}

