/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.OneToManyDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class OneToManySaveMethod
implements MethodDefinition {
    public static final String METHOD_SAVE = "save";
    public static final String METHOD_UPDATE = "update";
    public static final String METHOD_INSERT = "insert";
    private final TableDefinition tableDefinition;
    private final boolean isModelContainerAdapter;
    private final String methodName;
    private final boolean useWrapper;

    public OneToManySaveMethod(TableDefinition tableDefinition, boolean isModelContainerAdapter, String methodName, boolean useWrapper) {
        this.tableDefinition = tableDefinition;
        this.isModelContainerAdapter = isModelContainerAdapter;
        this.methodName = methodName;
        this.useWrapper = useWrapper;
    }

    @Override
    public MethodSpec getMethodSpec() {
        if (!this.tableDefinition.oneToManyDefinitions.isEmpty() || !this.isModelContainerAdapter && this.tableDefinition.cachingEnabled) {
            CodeBlock.Builder code = CodeBlock.builder();
            for (OneToManyDefinition oneToManyDefinition : this.tableDefinition.oneToManyDefinitions) {
                switch (this.methodName) {
                    case "save": {
                        oneToManyDefinition.writeSave(code, this.useWrapper);
                        break;
                    }
                    case "update": {
                        oneToManyDefinition.writeUpdate(code, this.useWrapper);
                        break;
                    }
                    case "insert": {
                        oneToManyDefinition.writeInsert(code, this.useWrapper);
                    }
                }
            }
            code.addStatement("super.$L($L$L)", new Object[]{this.methodName, ModelUtils.getVariable(this.isModelContainerAdapter), this.useWrapper ? ", " + ModelUtils.getWrapper() : ""});
            if (!this.isModelContainerAdapter && this.tableDefinition.cachingEnabled) {
                code.addStatement("getModelCache().addModel(getCachingId($L), $L)", new Object[]{ModelUtils.getVariable(this.isModelContainerAdapter), ModelUtils.getVariable(this.isModelContainerAdapter)});
            }
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)this.tableDefinition.elementClassName, ModelUtils.getVariable(this.isModelContainerAdapter), new Modifier[0]).addCode(code.build());
            if (this.useWrapper) {
                builder.addParameter((TypeName)ClassNames.DATABASE_WRAPPER, ModelUtils.getWrapper(), new Modifier[0]);
            }
            return builder.build();
        }
        return null;
    }
}

