/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class InsertStatementQueryMethod
implements MethodDefinition {
    private final TableDefinition tableDefinition;
    private final boolean isInsert;

    public InsertStatementQueryMethod(TableDefinition tableDefinition, boolean isInsert) {
        this.tableDefinition = tableDefinition;
        this.isInsert = isInsert;
    }

    @Override
    public MethodSpec getMethodSpec() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)(this.isInsert ? "getInsertStatementQuery" : "getCompiledStatementQuery")).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)ClassName.get(String.class));
        CodeBlock.Builder codeBuilder = CodeBlock.builder().add("INSERT ", new Object[0]);
        if (!this.tableDefinition.insertConflictActionName.isEmpty()) {
            codeBuilder.add("OR $L ", new Object[]{this.tableDefinition.insertConflictActionName});
        }
        codeBuilder.add("INTO ", new Object[0]).add(QueryBuilder.quote((String)this.tableDefinition.tableName), new Object[0]);
        boolean isSingleAutoincrement = this.tableDefinition.hasAutoIncrement() && this.tableDefinition.getColumnDefinitions().size() == 1 && this.isInsert;
        codeBuilder.add("(", new Object[0]);
        int columnSize = this.tableDefinition.getColumnDefinitions().size();
        int columnCount = 0;
        for (ColumnDefinition column : this.tableDefinition.getColumnDefinitions()) {
            if ((column.isPrimaryKeyAutoIncrement() || column.isRowId) && this.isInsert && !isSingleAutoincrement) continue;
            if (columnCount > 0) {
                codeBuilder.add(",", new Object[0]);
            }
            codeBuilder.add(column.getInsertStatementColumnName());
            ++columnCount;
        }
        codeBuilder.add(")", new Object[0]);
        codeBuilder.add(" VALUES (", new Object[0]);
        columnCount = 0;
        for (int i = 0; i < columnSize; ++i) {
            ColumnDefinition definition = this.tableDefinition.getColumnDefinitions().get(i);
            if ((definition.isPrimaryKeyAutoIncrement() || definition.isRowId) && this.isInsert) continue;
            if (columnCount > 0) {
                codeBuilder.add(",", new Object[0]);
            }
            codeBuilder.add(definition.getInsertStatementValuesString());
            ++columnCount;
        }
        if (isSingleAutoincrement) {
            codeBuilder.add("NULL", new Object[0]);
        }
        codeBuilder.add(")", new Object[0]);
        methodBuilder.addStatement("return $S", new Object[]{codeBuilder.build().toString()});
        return methodBuilder.build();
    }
}

