/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.Modifier;

public class BindToStatementMethod
implements MethodDefinition {
    public static final String PARAM_STATEMENT = "statement";
    public static final String PARAM_MODEL = "model";
    public static final String PARAM_START = "start";
    private TableDefinition tableDefinition;
    private boolean isInsert;
    private boolean isModelContainerAdapter;

    public BindToStatementMethod(TableDefinition tableDefinition, boolean isInsert, boolean isModelContainerAdapter) {
        this.tableDefinition = tableDefinition;
        this.isInsert = isInsert;
        this.isModelContainerAdapter = isModelContainerAdapter;
    }

    @Override
    public MethodSpec getMethodSpec() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)(this.isInsert ? "bindToInsertStatement" : "bindToStatement")).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)ClassNames.DATABASE_STATEMENT, PARAM_STATEMENT, new Modifier[0]).addParameter(this.tableDefinition.getParameterClassName(this.isModelContainerAdapter), ModelUtils.getVariable(this.isModelContainerAdapter), new Modifier[0]).returns(TypeName.VOID);
        if (this.isInsert) {
            methodBuilder.addParameter(TypeName.INT, PARAM_START, new Modifier[0]);
            List<ColumnDefinition> columnDefinitionList = this.tableDefinition.getColumnDefinitions();
            AtomicInteger realCount = new AtomicInteger(1);
            for (ColumnDefinition columnDefinition : columnDefinitionList) {
                if (columnDefinition.isPrimaryKeyAutoIncrement() || columnDefinition.isRowId) continue;
                methodBuilder.addCode(columnDefinition.getSQLiteStatementMethod(realCount, this.isModelContainerAdapter));
                realCount.incrementAndGet();
            }
            if (this.tableDefinition.implementsSqlStatementListener) {
                methodBuilder.addStatement("$L.onBindTo$LStatement($L)", new Object[]{ModelUtils.getVariable(this.isModelContainerAdapter), this.isInsert ? "Insert" : "", PARAM_STATEMENT});
            }
        } else {
            int start = 0;
            if (this.tableDefinition.hasAutoIncrement || this.tableDefinition.hasRowID) {
                ColumnDefinition autoIncrement = this.tableDefinition.autoIncrementDefinition;
                methodBuilder.addCode(autoIncrement.getSQLiteStatementMethod(new AtomicInteger(++start), this.isModelContainerAdapter));
            }
            methodBuilder.addStatement("bindToInsertStatement($L, $L, $L)", new Object[]{PARAM_STATEMENT, ModelUtils.getVariable(this.isModelContainerAdapter), start});
            if (this.tableDefinition.implementsSqlStatementListener) {
                methodBuilder.addStatement("$L.onBindTo$LStatement($L)", new Object[]{ModelUtils.getVariable(this.isModelContainerAdapter), this.isInsert ? "Insert" : "", PARAM_STATEMENT});
            }
        }
        return methodBuilder.build();
    }
}

