/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.Modifier;

public class BindToContentValuesMethod
implements MethodDefinition {
    public static final String PARAM_CONTENT_VALUES = "values";
    public static final String PARAM_MODEL = "model";
    private BaseTableDefinition baseTableDefinition;
    private final boolean isModelContainerAdapter;
    private boolean implementsContentValuesListener;
    private boolean isInsert;

    public BindToContentValuesMethod(BaseTableDefinition baseTableDefinition, boolean isInsert, boolean isModelContainerAdapter, boolean implementsContentValuesListener) {
        this.baseTableDefinition = baseTableDefinition;
        this.isModelContainerAdapter = isModelContainerAdapter;
        this.implementsContentValuesListener = implementsContentValuesListener;
        this.isInsert = isInsert;
    }

    @Override
    public MethodSpec getMethodSpec() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)(this.isInsert ? "bindToInsertValues" : "bindToContentValues")).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)ClassNames.CONTENT_VALUES, PARAM_CONTENT_VALUES, new Modifier[0]).addParameter(this.baseTableDefinition.getParameterClassName(this.isModelContainerAdapter), ModelUtils.getVariable(this.isModelContainerAdapter), new Modifier[0]).returns(TypeName.VOID);
        if (this.isInsert) {
            List<ColumnDefinition> columnDefinitionList = this.baseTableDefinition.getColumnDefinitions();
            for (ColumnDefinition columnDefinition : columnDefinitionList) {
                if (columnDefinition.isPrimaryKeyAutoIncrement() || columnDefinition.isRowId) continue;
                methodBuilder.addCode(columnDefinition.getContentValuesStatement(this.isModelContainerAdapter));
            }
            if (this.implementsContentValuesListener) {
                methodBuilder.addStatement("$L.onBindTo$LValues($L)", new Object[]{ModelUtils.getVariable(this.isModelContainerAdapter), this.isInsert ? "Insert" : "Content", PARAM_CONTENT_VALUES});
            }
        } else if (this.baseTableDefinition instanceof TableDefinition) {
            TableDefinition tableDefinition = (TableDefinition)this.baseTableDefinition;
            if (tableDefinition.hasAutoIncrement || tableDefinition.hasRowID) {
                ColumnDefinition autoIncrement = tableDefinition.autoIncrementDefinition;
                methodBuilder.addCode(autoIncrement.getContentValuesStatement(this.isModelContainerAdapter));
            }
            methodBuilder.addStatement("bindToInsertValues($L, $L)", new Object[]{PARAM_CONTENT_VALUES, ModelUtils.getVariable(this.isModelContainerAdapter)});
            if (this.implementsContentValuesListener) {
                methodBuilder.addStatement("$L.onBindTo$LValues($L)", new Object[]{ModelUtils.getVariable(this.isModelContainerAdapter), this.isInsert ? "Insert" : "Content", PARAM_CONTENT_VALUES});
            }
        }
        return methodBuilder.build();
    }
}

