/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.column;

import com.raizlabs.android.dbflow.data.Blob;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.SQLiteHelper;
import com.raizlabs.android.dbflow.processor.definition.TypeConverterDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.WrapperColumnAccess;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;

public class TypeConverterAccess
extends WrapperColumnAccess {
    private static final String METHOD_TYPE_CONVERTER = "getTypeConverterForClass";
    public final TypeConverterDefinition typeConverterDefinition;
    private final ProcessorManager manager;
    private String typeConverterFieldName;

    public TypeConverterAccess(ProcessorManager manager, ColumnDefinition columnDefinition) {
        super(columnDefinition);
        this.typeConverterDefinition = manager.getTypeConverterDefinition(columnDefinition.elementTypeName.box());
        this.manager = manager;
    }

    public TypeConverterAccess(ProcessorManager manager, ColumnDefinition columnDefinition, TypeConverterDefinition typeConverterDefinition, String typeConverterFieldName) {
        super(columnDefinition);
        this.manager = manager;
        this.typeConverterFieldName = typeConverterFieldName;
        this.typeConverterDefinition = typeConverterDefinition;
    }

    @Override
    public String getColumnAccessString(TypeName fieldType, String elementName, String fullElementName, String variableNameString, boolean isModelContainerAdapter, boolean isSqliteStatement) {
        this.checkConverter();
        if (this.typeConverterDefinition != null) {
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            if (this.typeConverterFieldName == null) {
                codeBuilder.add("($T) $T.$L($T.class)", new Object[]{this.typeConverterDefinition.getDbTypeName(), ClassNames.FLOW_MANAGER, METHOD_TYPE_CONVERTER, this.columnDefinition.elementTypeName.box()});
            } else {
                codeBuilder.add(this.typeConverterFieldName, new Object[0]);
            }
            codeBuilder.add(".getDBValue(($T) $L)", new Object[]{this.typeConverterDefinition.getModelTypeName(), this.getExistingColumnAccess().getColumnAccessString(fieldType, elementName, fullElementName, variableNameString, isModelContainerAdapter, isSqliteStatement)});
            return codeBuilder.build().toString();
        }
        return "";
    }

    @Override
    public String getShortAccessString(TypeName fieldType, String elementName, boolean isModelContainerAdapter, boolean isSqliteStatement) {
        this.checkConverter();
        if (this.typeConverterDefinition != null) {
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            if (this.typeConverterFieldName == null) {
                codeBuilder.add("($T) $T.$L($T.class)", new Object[]{this.typeConverterDefinition.getDbTypeName(), ClassNames.FLOW_MANAGER, METHOD_TYPE_CONVERTER, this.columnDefinition.elementTypeName.box()});
            } else {
                codeBuilder.add(this.typeConverterFieldName, new Object[0]);
            }
            codeBuilder.add(".getDBValue($L)", new Object[]{this.getExistingColumnAccess().getShortAccessString(fieldType, elementName, isModelContainerAdapter, isSqliteStatement)});
            return codeBuilder.build().toString();
        }
        return "";
    }

    @Override
    public String setColumnAccessString(TypeName fieldType, String elementName, String fullElementName, boolean isModelContainerAdapter, String variableNameString, CodeBlock formattedAccess, boolean toModel) {
        this.checkConverter();
        if (this.typeConverterDefinition != null) {
            CodeBlock.Builder newFormattedAccess = CodeBlock.builder();
            if (this.typeConverterFieldName == null) {
                newFormattedAccess.add("($T) $T.$L($T.class)", new Object[]{this.typeConverterDefinition.getModelTypeName(), ClassNames.FLOW_MANAGER, METHOD_TYPE_CONVERTER, this.columnDefinition.elementTypeName.box()}).build();
            } else {
                newFormattedAccess.add(this.typeConverterFieldName, new Object[0]);
            }
            String newCursorAccess = formattedAccess.toString();
            if (this.typeConverterDefinition.getDbTypeName().equals((Object)ClassName.get(Blob.class))) {
                newCursorAccess = CodeBlock.builder().add("new $T($L)", new Object[]{ClassName.get(Blob.class), newCursorAccess}).build().toString();
            }
            newFormattedAccess.add(".getModelValue($L)", new Object[]{newCursorAccess});
            return this.getExistingColumnAccess().setColumnAccessString(fieldType, elementName, fullElementName, isModelContainerAdapter, variableNameString, newFormattedAccess.build(), toModel);
        }
        return "";
    }

    @Override
    SQLiteHelper getSqliteTypeForTypeName(TypeName elementTypeName, boolean isModelContainerAdapter) {
        this.checkConverter();
        if (this.typeConverterDefinition != null) {
            return super.getSqliteTypeForTypeName(this.typeConverterDefinition.getDbTypeName(), isModelContainerAdapter);
        }
        return SQLiteHelper.TEXT;
    }

    private void checkConverter() {
        if (this.typeConverterDefinition == null) {
            this.manager.logError("No type converter for: " + this.columnDefinition.elementTypeName + " -> " + this.columnDefinition.elementName + " from class: " + this.columnDefinition.tableDefinition.elementClassName + ". Please" + "register with a TypeConverter.", new Object[0]);
        }
    }
}

