/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.column;

import com.raizlabs.android.dbflow.annotation.ForeignKeyReference;
import com.raizlabs.android.dbflow.processor.definition.column.BaseColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.DefinitionUtils;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ModelContainerAccess;
import com.raizlabs.android.dbflow.processor.definition.column.PackagePrivateAccess;
import com.raizlabs.android.dbflow.processor.definition.column.PrivateColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.SimpleColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.WrapperColumnAccess;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ElementUtility;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class ForeignKeyReferenceDefinition {
    private final ProcessorManager manager;
    private final String foreignKeyFieldName;
    public final String columnName;
    public final String foreignColumnName;
    public final TypeName columnClassName;
    private boolean isReferencedFieldPrivate;
    private boolean isReferencedFieldPackagePrivate;
    public BaseColumnAccess columnAccess;
    private final BaseColumnAccess tableColumnAccess;
    private final ForeignKeyColumnDefinition foreignKeyColumnDefinition;
    private final BaseColumnAccess simpleColumnAccess;

    public ForeignKeyReferenceDefinition(ProcessorManager manager, String foreignKeyFieldName, ColumnDefinition referencedColumn, BaseColumnAccess tableColumnAccess, ForeignKeyColumnDefinition foreignKeyColumnDefinition, int referenceCount) {
        this.manager = manager;
        this.foreignKeyColumnDefinition = foreignKeyColumnDefinition;
        this.tableColumnAccess = tableColumnAccess;
        this.foreignKeyFieldName = foreignKeyFieldName;
        this.columnName = !foreignKeyColumnDefinition.isPrimaryKey && !foreignKeyColumnDefinition.isPrimaryKeyAutoIncrement() && !foreignKeyColumnDefinition.isRowId || referenceCount > 0 ? foreignKeyFieldName + "_" + referencedColumn.columnName : foreignKeyFieldName;
        this.foreignColumnName = referencedColumn.columnName;
        this.columnClassName = referencedColumn.elementTypeName;
        if (referencedColumn.columnAccess instanceof WrapperColumnAccess) {
            this.isReferencedFieldPrivate = ((WrapperColumnAccess)referencedColumn.columnAccess).existingColumnAccess instanceof PrivateColumnAccess;
            this.isReferencedFieldPackagePrivate = ((WrapperColumnAccess)referencedColumn.columnAccess).existingColumnAccess instanceof PackagePrivateAccess;
        } else {
            this.isReferencedFieldPrivate = referencedColumn.columnAccess instanceof PrivateColumnAccess;
            boolean isPackagePrivate = ElementUtility.isPackagePrivate(referencedColumn.element);
            boolean isPackagePrivateNotInSamePackage = isPackagePrivate && !ElementUtility.isInSamePackage(manager, referencedColumn.element, foreignKeyColumnDefinition.element);
            boolean bl = this.isReferencedFieldPackagePrivate = referencedColumn.columnAccess instanceof PackagePrivateAccess || isPackagePrivateNotInSamePackage;
        }
        if (this.isReferencedFieldPrivate && !foreignKeyColumnDefinition.isModelContainer) {
            this.columnAccess = new PrivateColumnAccess(referencedColumn.column, false);
        } else if (this.isReferencedFieldPackagePrivate && !foreignKeyColumnDefinition.isModelContainer) {
            this.columnAccess = new PackagePrivateAccess(referencedColumn.packageName, foreignKeyColumnDefinition.tableDefinition.databaseDefinition.classSeparator, ClassName.get((TypeElement)((TypeElement)referencedColumn.element.getEnclosingElement())).simpleName());
            PackagePrivateAccess.putElement(((PackagePrivateAccess)this.columnAccess).helperClassName, this.foreignColumnName);
        } else {
            this.columnAccess = foreignKeyColumnDefinition.isModelContainer ? new ModelContainerAccess(tableColumnAccess, this.foreignColumnName) : new SimpleColumnAccess();
        }
        this.simpleColumnAccess = new SimpleColumnAccess(this.columnAccess instanceof PackagePrivateAccess);
    }

    public ForeignKeyReferenceDefinition(ProcessorManager manager, String foreignKeyFieldName, ForeignKeyReference foreignKeyReference, BaseColumnAccess tableColumnAccess, ForeignKeyColumnDefinition foreignKeyColumnDefinition) {
        this.manager = manager;
        this.tableColumnAccess = tableColumnAccess;
        this.foreignKeyColumnDefinition = foreignKeyColumnDefinition;
        this.foreignKeyFieldName = foreignKeyFieldName;
        this.columnName = foreignKeyReference.columnName();
        this.foreignColumnName = foreignKeyReference.foreignKeyColumnName();
        TypeMirror columnClass = null;
        try {
            foreignKeyReference.columnType();
        }
        catch (MirroredTypeException mte) {
            columnClass = mte.getTypeMirror();
        }
        this.columnClassName = TypeName.get((TypeMirror)columnClass);
        this.isReferencedFieldPrivate = foreignKeyReference.referencedFieldIsPrivate();
        this.isReferencedFieldPackagePrivate = foreignKeyReference.referencedFieldIsPackagePrivate();
        if (this.isReferencedFieldPrivate && !foreignKeyColumnDefinition.isModelContainer) {
            this.columnAccess = new PrivateColumnAccess(foreignKeyReference);
        } else if (this.isReferencedFieldPackagePrivate && !foreignKeyColumnDefinition.isModelContainer) {
            this.columnAccess = new PackagePrivateAccess(foreignKeyColumnDefinition.referencedTableClassName.packageName(), foreignKeyColumnDefinition.tableDefinition.databaseDefinition.classSeparator, foreignKeyColumnDefinition.referencedTableClassName.simpleName());
            PackagePrivateAccess.putElement(((PackagePrivateAccess)this.columnAccess).helperClassName, this.foreignColumnName);
        } else {
            this.columnAccess = foreignKeyColumnDefinition.isModelContainer ? new ModelContainerAccess(tableColumnAccess, this.foreignColumnName) : new SimpleColumnAccess();
        }
        this.simpleColumnAccess = new SimpleColumnAccess(this.columnAccess instanceof PackagePrivateAccess);
    }

    CodeBlock getCreationStatement() {
        return DefinitionUtils.getCreationStatement(this.columnClassName, null, this.columnName).build();
    }

    String getPrimaryKeyName() {
        return QueryBuilder.quote((String)this.columnName);
    }

    CodeBlock getContentValuesStatement(boolean isModelContainerAdapter) {
        String shortAccess = this.tableColumnAccess.getShortAccessString((TypeName)this.foreignKeyColumnDefinition.elementClassName, this.foreignKeyFieldName, isModelContainerAdapter, false);
        shortAccess = this.foreignKeyColumnDefinition.getForeignKeyReferenceAccess(isModelContainerAdapter, shortAccess);
        String columnShortAccess = this.getShortColumnAccess(isModelContainerAdapter, false, shortAccess);
        String combined = !(this.columnAccess instanceof PackagePrivateAccess) ? shortAccess + (isModelContainerAdapter ? "" : ".") + columnShortAccess : columnShortAccess;
        return DefinitionUtils.getContentValuesStatement(columnShortAccess, combined, this.columnName, this.columnClassName, isModelContainerAdapter, this.simpleColumnAccess, this.getForeignKeyColumnVariable(isModelContainerAdapter), null, this.foreignKeyColumnDefinition.tableDefinition.outputClassName).build();
    }

    public String getPrimaryReferenceString(boolean isModelContainerAdapter) {
        String shortAccess = this.tableColumnAccess.getShortAccessString((TypeName)this.foreignKeyColumnDefinition.elementClassName, this.foreignKeyFieldName, isModelContainerAdapter, false);
        shortAccess = this.foreignKeyColumnDefinition.getForeignKeyReferenceAccess(isModelContainerAdapter, shortAccess);
        String columnShortAccess = this.getShortColumnAccess(isModelContainerAdapter, false, shortAccess);
        String combined = !(this.columnAccess instanceof PackagePrivateAccess) ? ModelUtils.getVariable(isModelContainerAdapter) + "." + shortAccess + (isModelContainerAdapter ? "" : ".") + columnShortAccess : columnShortAccess;
        return combined;
    }

    CodeBlock getSQLiteStatementMethod(AtomicInteger index, boolean isModelContainerAdapter) {
        String shortAccess = this.tableColumnAccess.getShortAccessString((TypeName)this.foreignKeyColumnDefinition.elementClassName, this.foreignKeyFieldName, isModelContainerAdapter, true);
        shortAccess = this.foreignKeyColumnDefinition.getForeignKeyReferenceAccess(isModelContainerAdapter, shortAccess);
        String columnShortAccess = this.getShortColumnAccess(isModelContainerAdapter, true, shortAccess);
        String combined = shortAccess + (isModelContainerAdapter ? "" : ".") + columnShortAccess;
        return DefinitionUtils.getSQLiteStatementMethod(index, columnShortAccess, combined, this.columnClassName, isModelContainerAdapter, this.simpleColumnAccess, this.getForeignKeyColumnVariable(isModelContainerAdapter), false, null).build();
    }

    CodeBlock getForeignKeyContainerMethod(ClassName tableClassName) {
        String access = this.getShortColumnAccess(false, false, this.tableColumnAccess.getShortAccessString((TypeName)this.foreignKeyColumnDefinition.elementClassName, this.foreignKeyFieldName, false, false));
        if (this.foreignKeyColumnDefinition.isModelContainer) {
            access = this.foreignKeyColumnDefinition.getColumnAccessString(false, false) + "." + access;
        } else if (this.foreignKeyColumnDefinition.isModel && !this.isReferencedFieldPackagePrivate) {
            access = this.foreignKeyColumnDefinition.getColumnAccessString(false, false) + "." + access;
        }
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        codeBuilder.addStatement("$L.put($T.$L, $L)", new Object[]{ModelUtils.getVariable(true), tableClassName, this.columnName, access});
        return codeBuilder.build();
    }

    private String getForeignKeyColumnVariable(boolean isModelContainerAdapter) {
        return isModelContainerAdapter ? this.foreignKeyColumnDefinition.getRefName() : ModelUtils.getVariable(isModelContainerAdapter);
    }

    private String getShortColumnAccess(boolean isModelContainerAdapter, boolean isSqliteMethod, String shortAccess) {
        if (isModelContainerAdapter) {
            return this.foreignColumnName;
        }
        if (this.columnAccess instanceof PackagePrivateAccess) {
            return this.columnAccess.getColumnAccessString(this.columnClassName, this.foreignColumnName, "", ModelUtils.getVariable(isModelContainerAdapter) + "." + shortAccess, isModelContainerAdapter, isSqliteMethod);
        }
        return this.columnAccess.getShortAccessString(this.columnClassName, this.foreignColumnName, isModelContainerAdapter, isSqliteMethod);
    }
}

