/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.column;

import com.raizlabs.android.dbflow.annotation.ContainerKey;
import com.raizlabs.android.dbflow.processor.SQLiteHelper;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.BaseColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.BooleanColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.EnumColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.PackagePrivateAccess;
import com.raizlabs.android.dbflow.processor.definition.column.PrivateColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.SimpleColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.TypeConverterAccess;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public class ContainerKeyDefinition
extends BaseDefinition {
    private BaseColumnAccess columnAccess;
    public String containerKeyName;

    public ContainerKeyDefinition(Element element, ProcessorManager processorManager, BaseTableDefinition baseTableDefinition, boolean isPackagePrivate) {
        super(element, processorManager);
        ContainerKey containerKey = element.getAnnotation(ContainerKey.class);
        if (containerKey != null) {
            this.containerKeyName = containerKey.value();
            if (StringUtils.isNullOrEmpty(this.containerKeyName)) {
                this.containerKeyName = this.elementName;
            }
        } else {
            this.containerKeyName = this.elementName;
        }
        if (isPackagePrivate) {
            this.columnAccess = PackagePrivateAccess.from(processorManager, element, baseTableDefinition.databaseDefinition.classSeparator);
            PackagePrivateAccess.putElement(((PackagePrivateAccess)this.columnAccess).helperClassName, this.containerKeyName);
        } else {
            boolean isPrivate = element.getModifiers().contains((Object)Modifier.PRIVATE);
            if (isPrivate) {
                boolean useIs = this.elementTypeName.box().equals((Object)TypeName.BOOLEAN.box()) && baseTableDefinition instanceof TableDefinition && ((TableDefinition)baseTableDefinition).useIsForPrivateBooleans;
                this.columnAccess = new PrivateColumnAccess(useIs);
            } else {
                this.columnAccess = new SimpleColumnAccess();
            }
        }
    }

    public CodeBlock getToModelMethod() {
        String method = SQLiteHelper.getModelContainerMethod(this.elementTypeName);
        if (method == null) {
            if (this.columnAccess instanceof EnumColumnAccess) {
                method = SQLiteHelper.getModelContainerMethod((TypeName)ClassName.get(String.class));
            } else {
                if (this.columnAccess instanceof TypeConverterAccess) {
                    method = SQLiteHelper.getModelContainerMethod(((TypeConverterAccess)this.columnAccess).typeConverterDefinition.getDbTypeName());
                }
                if (method == null) {
                    this.manager.logError("ToModel typename: %1s", this.elementTypeName);
                    method = "get";
                }
            }
        }
        CodeBlock.Builder codeBuilder = CodeBlock.builder().add("$L.$LValue($S)", new Object[]{ModelUtils.getVariable(true), method, this.containerKeyName});
        BaseColumnAccess columnAccessToUse = this.columnAccess;
        if (this.columnAccess instanceof BooleanColumnAccess || this.columnAccess instanceof TypeConverterAccess && ((TypeConverterAccess)this.columnAccess).typeConverterDefinition.getModelTypeName().equals((Object)TypeName.BOOLEAN.box())) {
            columnAccessToUse = ((TypeConverterAccess)this.columnAccess).existingColumnAccess;
        }
        return CodeBlock.builder().addStatement(columnAccessToUse.setColumnAccessString(this.elementTypeName, this.containerKeyName, this.elementName, false, ModelUtils.getVariable(false), codeBuilder.build(), true), new Object[0]).build();
    }
}

