/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.annotation.ModelContainer;
import com.raizlabs.android.dbflow.annotation.QueryModel;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.ProcessorUtils;
import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.InternalAdapterHelper;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.CustomTypeConverterPropertyMethod;
import com.raizlabs.android.dbflow.processor.definition.method.LoadFromCursorMethod;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ElementUtility;
import com.raizlabs.android.dbflow.processor.validator.ColumnValidator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class QueryModelDefinition
extends BaseTableDefinition {
    private static final String DBFLOW_QUERY_MODEL_TAG = "QueryModel";
    public static final String DBFLOW_TABLE_ADAPTER = "QueryModelAdapter";
    public TypeName databaseTypeName;
    public boolean allFields;
    public String adapterName;
    public boolean implementsLoadFromCursorListener = false;
    MethodDefinition[] methods;

    public QueryModelDefinition(Element typeElement, ProcessorManager processorManager) {
        super(typeElement, processorManager);
        ModelContainer containerKey = this.element.getAnnotation(ModelContainer.class);
        boolean putDefaultValue = containerKey != null && containerKey.putDefault();
        QueryModel queryModel = typeElement.getAnnotation(QueryModel.class);
        if (queryModel != null) {
            try {
                queryModel.database();
            }
            catch (MirroredTypeException mte) {
                this.databaseTypeName = TypeName.get((TypeMirror)mte.getTypeMirror());
            }
        }
        processorManager.addModelToDatabase((TypeName)this.elementClassName, this.databaseTypeName);
        if (this.element instanceof TypeElement) {
            this.implementsLoadFromCursorListener = ProcessorUtils.implementsClass(this.manager.getProcessingEnvironment(), ClassNames.LOAD_FROM_CURSOR_LISTENER.toString(), (TypeElement)this.element);
        }
        this.methods = new MethodDefinition[]{new LoadFromCursorMethod(this, false, this.implementsLoadFromCursorListener, putDefaultValue)};
    }

    @Override
    public void prepareForWrite() {
        this.classElementLookUpMap.clear();
        this.columnDefinitions.clear();
        this.packagePrivateList.clear();
        QueryModel queryModel = this.typeElement.getAnnotation(QueryModel.class);
        if (queryModel != null) {
            this.databaseDefinition = this.manager.getDatabaseHolderDefinition(this.databaseTypeName).getDatabaseDefinition();
            this.setOutputClassName(this.databaseDefinition.classSeparator + DBFLOW_QUERY_MODEL_TAG);
            this.allFields = queryModel.allFields();
            this.adapterName = this.getModelClassName() + this.databaseDefinition.classSeparator + DBFLOW_TABLE_ADAPTER;
            if (this.typeElement instanceof TypeElement) {
                this.createColumnDefinitions(this.typeElement);
            }
        }
    }

    @Override
    public void onWriteDefinition(TypeSpec.Builder typeBuilder) {
        for (ColumnDefinition columnDefinition : this.columnDefinitions) {
            columnDefinition.addPropertyDefinition(typeBuilder, (TypeName)this.elementClassName);
        }
    }

    @Override
    protected void createColumnDefinitions(TypeElement typeElement) {
        List<? extends Element> variableElements = ElementUtility.getAllElements(typeElement, this.manager);
        for (Element element : variableElements) {
            this.classElementLookUpMap.put(element.getSimpleName().toString(), element);
        }
        ColumnValidator columnValidator = new ColumnValidator();
        for (Element element : variableElements) {
            ColumnDefinition columnDefinition;
            boolean isPackagePrivateNotInSamePackage;
            boolean isAllFields = ElementUtility.isValidAllFields(this.allFields, this.element);
            boolean isPackagePrivate = ElementUtility.isPackagePrivate(this.element);
            boolean bl = isPackagePrivateNotInSamePackage = isPackagePrivate && !ElementUtility.isInSamePackage(this.manager, this.element, this.element);
            if (element.getAnnotation(Column.class) == null && !isAllFields || !columnValidator.validate(this.manager, columnDefinition = new ColumnDefinition(this.manager, element, this, isPackagePrivateNotInSamePackage))) continue;
            this.columnDefinitions.add(columnDefinition);
            if (!isPackagePrivate) continue;
            this.packagePrivateList.add(columnDefinition);
        }
    }

    @Override
    public List<ColumnDefinition> getPrimaryColumnDefinitions() {
        return new ArrayList<ColumnDefinition>();
    }

    @Override
    public ClassName getPropertyClassName() {
        return this.outputClassName;
    }

    public ClassName getAdapterClassName() {
        return ClassName.get((String)this.packageName, (String)this.adapterName, (String[])new String[0]);
    }

    public void writeAdapter(ProcessingEnvironment processingEnvironment) throws IOException {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)this.adapterName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.QUERY_MODEL_ADAPTER, (TypeName[])new TypeName[]{this.elementClassName}));
        CustomTypeConverterPropertyMethod customTypeConverterPropertyMethod = new CustomTypeConverterPropertyMethod(this);
        customTypeConverterPropertyMethod.addToType(typeBuilder);
        CodeBlock.Builder constructorCode = CodeBlock.builder();
        constructorCode.addStatement("super(databaseDefinition)", new Object[0]);
        customTypeConverterPropertyMethod.addCode(constructorCode);
        InternalAdapterHelper.writeGetModelClass(typeBuilder, this.elementClassName);
        typeBuilder.addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)ClassNames.DATABASE_HOLDER, "holder", new Modifier[0]).addParameter((TypeName)ClassNames.BASE_DATABASE_DEFINITION_CLASSNAME, "databaseDefinition", new Modifier[0]).addCode(constructorCode.build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        for (MethodDefinition method : this.methods) {
            MethodSpec methodSpec = method.getMethodSpec();
            if (methodSpec == null) continue;
            typeBuilder.addMethod(methodSpec);
        }
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"newInstance").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)this.elementClassName).addStatement("return new $T()", new Object[]{this.elementClassName}).build());
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)typeBuilder.build()).build();
        javaFile.writeTo(processingEnvironment.getFiler());
    }
}

