/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.annotation.ModelContainer;
import com.raizlabs.android.dbflow.annotation.ModelView;
import com.raizlabs.android.dbflow.annotation.ModelViewQuery;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.ProcessorUtils;
import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.InternalAdapterHelper;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.CustomTypeConverterPropertyMethod;
import com.raizlabs.android.dbflow.processor.definition.method.ExistenceMethod;
import com.raizlabs.android.dbflow.processor.definition.method.LoadFromCursorMethod;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.PrimaryConditionMethod;
import com.raizlabs.android.dbflow.processor.handler.DatabaseHandler;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ElementUtility;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.raizlabs.android.dbflow.processor.validator.ColumnValidator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class ModelViewDefinition
extends BaseTableDefinition
implements Comparable<ModelViewDefinition> {
    private static final String DBFLOW_MODEL_VIEW_TAG = "View";
    private static final String TABLE_VIEW_TAG = "ViewTable";
    final boolean implementsLoadFromCursorListener;
    public TypeName databaseName;
    private String queryFieldName;
    private String name;
    private ClassName modelReferenceClass;
    private MethodDefinition[] methods;
    public String viewTableName;
    public boolean allFields;
    public int priority;

    public ModelViewDefinition(ProcessorManager manager, Element element) {
        super(element, manager);
        ModelContainer containerKey = element.getAnnotation(ModelContainer.class);
        boolean putDefaultValue = containerKey != null && containerKey.putDefault();
        ModelView modelView = element.getAnnotation(ModelView.class);
        if (modelView != null) {
            try {
                modelView.database();
            }
            catch (MirroredTypeException mte) {
                this.databaseName = TypeName.get((TypeMirror)mte.getTypeMirror());
            }
            this.allFields = modelView.allFields();
            this.name = modelView.name();
            if (this.name == null || this.name.isEmpty()) {
                this.name = this.getModelClassName();
            }
            this.priority = modelView.priority();
        }
        DeclaredType typeAdapterInterface = null;
        DeclaredType modelViewType = manager.getTypeUtils().getDeclaredType(manager.getElements().getTypeElement(ClassNames.MODEL_VIEW.toString()), manager.getTypeUtils().getWildcardType(manager.getElements().getTypeElement(ClassNames.MODEL.toString()).asType(), null));
        for (TypeMirror typeMirror : manager.getTypeUtils().directSupertypes(element.asType())) {
            if (!manager.getTypeUtils().isAssignable(typeMirror, modelViewType)) continue;
            typeAdapterInterface = (DeclaredType)typeMirror;
            break;
        }
        if (typeAdapterInterface != null) {
            List<? extends TypeMirror> typeArguments = typeAdapterInterface.getTypeArguments();
            this.modelReferenceClass = ClassName.get((TypeElement)manager.getElements().getTypeElement(typeArguments.get(0).toString()));
        }
        this.implementsLoadFromCursorListener = element instanceof TypeElement ? ProcessorUtils.implementsClass(manager.getProcessingEnvironment(), ClassNames.LOAD_FROM_CURSOR_LISTENER.toString(), (TypeElement)element) : false;
        this.methods = new MethodDefinition[]{new LoadFromCursorMethod(this, false, this.implementsLoadFromCursorListener, putDefaultValue), new ExistenceMethod(this, false), new PrimaryConditionMethod(this, false)};
    }

    @Override
    public void prepareForWrite() {
        this.classElementLookUpMap.clear();
        this.columnDefinitions.clear();
        this.queryFieldName = null;
        ModelView modelView = this.element.getAnnotation(ModelView.class);
        if (modelView != null) {
            this.databaseDefinition = this.manager.getDatabaseHolderDefinition(this.databaseName).getDatabaseDefinition();
            this.viewTableName = this.getModelClassName() + this.databaseDefinition.classSeparator + TABLE_VIEW_TAG;
            this.setOutputClassName(this.databaseDefinition.classSeparator + DBFLOW_MODEL_VIEW_TAG);
            if (this.typeElement != null) {
                this.createColumnDefinitions(this.typeElement);
            }
        }
    }

    @Override
    protected void createColumnDefinitions(TypeElement typeElement) {
        List<? extends Element> variableElements = ElementUtility.getAllElements(typeElement, this.manager);
        for (Element element : variableElements) {
            this.classElementLookUpMap.put(element.getSimpleName().toString(), element);
        }
        ColumnValidator columnValidator = new ColumnValidator();
        for (Element element : variableElements) {
            boolean isValidAllFields = ElementUtility.isValidAllFields(this.allFields, this.element);
            if (element.getAnnotation(Column.class) != null || isValidAllFields) {
                boolean isPackagePrivate = ElementUtility.isPackagePrivate(this.element);
                boolean isPackagePrivateNotInSamePackage = isPackagePrivate && !ElementUtility.isInSamePackage(this.manager, this.element, this.element);
                ColumnDefinition columnDefinition = new ColumnDefinition(this.manager, element, this, isPackagePrivateNotInSamePackage);
                if (columnValidator.validate(this.manager, columnDefinition)) {
                    this.columnDefinitions.add(columnDefinition);
                    if (isPackagePrivate) {
                        this.columnDefinitions.add(columnDefinition);
                    }
                }
                if (!columnDefinition.isPrimaryKey && !(columnDefinition instanceof ForeignKeyColumnDefinition) && !columnDefinition.isPrimaryKeyAutoIncrement() && !columnDefinition.isRowId) continue;
                this.manager.logError("ModelViews cannot have primary or foreign keys", new Object[0]);
                continue;
            }
            if (element.getAnnotation(ModelViewQuery.class) == null) continue;
            if (!StringUtils.isNullOrEmpty(this.queryFieldName)) {
                this.manager.logError("Found duplicate ", new Object[0]);
            }
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.manager.logError("The ModelViewQuery must be public", new Object[0]);
            }
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                this.manager.logError("The ModelViewQuery must be static", new Object[0]);
            }
            if (!element.getModifiers().contains((Object)Modifier.FINAL)) {
                this.manager.logError("The ModelViewQuery must be final", new Object[0]);
            }
            TypeElement element2 = this.manager.getElements().getTypeElement(element.asType().toString());
            if (!ProcessorUtils.implementsClass(this.manager.getProcessingEnvironment(), ClassNames.QUERY.toString(), element2)) {
                this.manager.logError("The field %1s must implement %1s", element.getSimpleName().toString(), ClassNames.QUERY.toString());
            }
            this.queryFieldName = element.getSimpleName().toString();
        }
        if (StringUtils.isNullOrEmpty(this.queryFieldName)) {
            this.manager.logError("%1s is missing the @ModelViewQuery field.", this.elementClassName);
        }
    }

    @Override
    public List<ColumnDefinition> getPrimaryColumnDefinitions() {
        return this.getColumnDefinitions();
    }

    @Override
    public ClassName getPropertyClassName() {
        return ClassName.get((String)this.packageName, (String)this.viewTableName, (String[])new String[0]);
    }

    @Override
    protected TypeName getExtendsClass() {
        return ParameterizedTypeName.get((ClassName)ClassNames.MODEL_VIEW_ADAPTER, (TypeName[])new TypeName[]{this.modelReferenceClass, this.elementClassName});
    }

    public void writeViewTable() throws IOException {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)this.viewTableName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"VIEW_NAME", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.name}).build());
        for (ColumnDefinition columnDefinition : this.columnDefinitions) {
            columnDefinition.addPropertyDefinition(typeBuilder, (TypeName)this.elementClassName);
        }
        JavaFile file = JavaFile.builder((String)this.packageName, (TypeSpec)typeBuilder.build()).build();
        file.writeTo(this.manager.getProcessingEnvironment().getFiler());
    }

    @Override
    public void onWriteDefinition(TypeSpec.Builder typeBuilder) {
        CustomTypeConverterPropertyMethod customTypeConverterPropertyMethod = new CustomTypeConverterPropertyMethod(this);
        customTypeConverterPropertyMethod.addToType(typeBuilder);
        CodeBlock.Builder constructorCode = CodeBlock.builder();
        constructorCode.addStatement("super(databaseDefinition)", new Object[0]);
        customTypeConverterPropertyMethod.addCode(constructorCode);
        typeBuilder.addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)ClassNames.DATABASE_HOLDER, "holder", new Modifier[0]).addParameter((TypeName)ClassNames.BASE_DATABASE_DEFINITION_CLASSNAME, "databaseDefinition", new Modifier[0]).addCode(constructorCode.build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        for (MethodDefinition method : this.methods) {
            MethodSpec methodSpec = method.getMethodSpec();
            if (methodSpec == null) continue;
            typeBuilder.addMethod(methodSpec);
        }
        InternalAdapterHelper.writeGetModelClass(typeBuilder, this.elementClassName);
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getCreationQuery").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return $T.$L.getQuery()", new Object[]{this.elementClassName, this.queryFieldName}).returns((TypeName)ClassName.get(String.class)).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getViewName").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return $S", new Object[]{this.name}).returns((TypeName)ClassName.get(String.class)).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"newInstance").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return new $T()", new Object[]{this.elementClassName}).returns((TypeName)this.elementClassName).build());
    }

    @Override
    public int compareTo(ModelViewDefinition o) {
        return Integer.valueOf(this.priority).compareTo(o.priority);
    }
}

