/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.annotation.ModelContainer;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.InternalAdapterHelper;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.BindToContentValuesMethod;
import com.raizlabs.android.dbflow.processor.definition.method.BindToStatementMethod;
import com.raizlabs.android.dbflow.processor.definition.method.CustomTypeConverterPropertyMethod;
import com.raizlabs.android.dbflow.processor.definition.method.ExistenceMethod;
import com.raizlabs.android.dbflow.processor.definition.method.ForeignKeyContainerMethod;
import com.raizlabs.android.dbflow.processor.definition.method.LoadFromCursorMethod;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.PrimaryConditionMethod;
import com.raizlabs.android.dbflow.processor.definition.method.ToModelMethod;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class ModelContainerDefinition
extends BaseDefinition {
    public static final String DBFLOW_MODEL_CONTAINER_TAG = "Container";
    private MethodDefinition[] methods;
    public TableDefinition tableDefinition;

    public ModelContainerDefinition(TypeElement classElement, ProcessorManager manager) {
        super(classElement, manager);
    }

    public void prepareForWrite() {
        ModelContainer containerKey = this.typeElement.getAnnotation(ModelContainer.class);
        if (containerKey != null) {
            this.tableDefinition = this.manager.getTableDefinition(this.manager.getDatabase(this.elementTypeName), this.elementTypeName);
            if (this.tableDefinition == null) {
                this.manager.logError("Could not find a table definition for " + this.elementClassName + " ensure" + "that you have added a @Table definition for it.", new Object[0]);
                return;
            }
            this.setOutputClassName(this.tableDefinition.databaseDefinition.classSeparator + DBFLOW_MODEL_CONTAINER_TAG);
            boolean putDefaultValue = containerKey.putDefault();
            this.methods = new MethodDefinition[]{new BindToContentValuesMethod(this.tableDefinition, true, true, this.tableDefinition.implementsContentValuesListener), new BindToContentValuesMethod(this.tableDefinition, false, true, this.tableDefinition.implementsContentValuesListener), new BindToStatementMethod(this.tableDefinition, true, true), new BindToStatementMethod(this.tableDefinition, false, true), new ExistenceMethod(this.tableDefinition, true), new PrimaryConditionMethod(this.tableDefinition, true), new ToModelMethod(this.tableDefinition), new LoadFromCursorMethod(this.tableDefinition, true, this.tableDefinition.implementsLoadFromCursorListener, putDefaultValue), new ForeignKeyContainerMethod(this.tableDefinition)};
        }
    }

    public TypeName getDatabaseName() {
        return this.tableDefinition.databaseTypeName;
    }

    @Override
    protected TypeName getExtendsClass() {
        return ParameterizedTypeName.get((ClassName)ClassNames.MODEL_CONTAINER_ADAPTER, (TypeName[])new TypeName[]{this.elementClassName});
    }

    @Override
    public void onWriteDefinition(TypeSpec.Builder typeBuilder) {
        CustomTypeConverterPropertyMethod customTypeConverterPropertyMethod = new CustomTypeConverterPropertyMethod(this.tableDefinition);
        customTypeConverterPropertyMethod.addToType(typeBuilder);
        CodeBlock.Builder constructorCode = CodeBlock.builder();
        constructorCode.addStatement("super(databaseDefinition)", new Object[0]);
        for (ColumnDefinition columnDefinition : this.tableDefinition.columnDefinitions) {
            constructorCode.addStatement("$L.put($S, $T.class)", new Object[]{"columnMap", columnDefinition.columnName, columnDefinition.erasedTypeName});
        }
        customTypeConverterPropertyMethod.addCode(constructorCode);
        typeBuilder.addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)ClassNames.DATABASE_HOLDER, "holder", new Modifier[0]).addParameter((TypeName)ClassNames.BASE_DATABASE_DEFINITION_CLASSNAME, "databaseDefinition", new Modifier[0]).addCode(constructorCode.build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        InternalAdapterHelper.writeGetModelClass(typeBuilder, this.elementClassName);
        InternalAdapterHelper.writeGetTableName(typeBuilder, this.tableDefinition.tableName);
        for (MethodDefinition method : this.methods) {
            MethodSpec methodSpec = method.getMethodSpec();
            if (methodSpec == null) continue;
            typeBuilder.addMethod(methodSpec);
        }
    }
}

