/*
 * Decompiled with CFR 0.152.
 */
package com.owen.tab;

import android.view.animation.Interpolator;

class ValueAnimatorCompat {
    private final Impl mImpl;

    ValueAnimatorCompat(Impl impl) {
        this.mImpl = impl;
    }

    public void start() {
        this.mImpl.start();
    }

    public boolean isRunning() {
        return this.mImpl.isRunning();
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mImpl.setInterpolator(interpolator);
    }

    public void setUpdateListener(final AnimatorUpdateListener updateListener) {
        if (updateListener != null) {
            this.mImpl.setUpdateListener(new Impl.AnimatorUpdateListenerProxy(){

                @Override
                public void onAnimationUpdate() {
                    updateListener.onAnimationUpdate(ValueAnimatorCompat.this);
                }
            });
        } else {
            this.mImpl.setUpdateListener(null);
        }
    }

    public void setListener(final AnimatorListener listener) {
        if (listener != null) {
            this.mImpl.setListener(new Impl.AnimatorListenerProxy(){

                @Override
                public void onAnimationStart() {
                    listener.onAnimationStart(ValueAnimatorCompat.this);
                }

                @Override
                public void onAnimationEnd() {
                    listener.onAnimationEnd(ValueAnimatorCompat.this);
                }

                @Override
                public void onAnimationCancel() {
                    listener.onAnimationCancel(ValueAnimatorCompat.this);
                }
            });
        } else {
            this.mImpl.setListener(null);
        }
    }

    public void setIntValues(int from, int to) {
        this.mImpl.setIntValues(from, to);
    }

    public int getAnimatedIntValue() {
        return this.mImpl.getAnimatedIntValue();
    }

    public void setFloatValues(float from, float to) {
        this.mImpl.setFloatValues(from, to);
    }

    public float getAnimatedFloatValue() {
        return this.mImpl.getAnimatedFloatValue();
    }

    public void setDuration(long duration) {
        this.mImpl.setDuration(duration);
    }

    public void cancel() {
        this.mImpl.cancel();
    }

    public float getAnimatedFraction() {
        return this.mImpl.getAnimatedFraction();
    }

    public void end() {
        this.mImpl.end();
    }

    public long getDuration() {
        return this.mImpl.getDuration();
    }

    public void setStartDelay(long startDelay) {
        this.mImpl.setStartDelay(startDelay);
    }

    public static abstract class Impl {
        abstract void start();

        abstract boolean isRunning();

        abstract void setInterpolator(Interpolator var1);

        abstract void setListener(AnimatorListenerProxy var1);

        abstract void setUpdateListener(AnimatorUpdateListenerProxy var1);

        abstract void setIntValues(int var1, int var2);

        abstract int getAnimatedIntValue();

        abstract void setFloatValues(float var1, float var2);

        abstract float getAnimatedFloatValue();

        abstract void setDuration(long var1);

        abstract void cancel();

        abstract float getAnimatedFraction();

        abstract void end();

        abstract long getDuration();

        abstract void setStartDelay(long var1);

        public static interface AnimatorListenerProxy {
            public void onAnimationStart();

            public void onAnimationEnd();

            public void onAnimationCancel();
        }

        public static interface AnimatorUpdateListenerProxy {
            public void onAnimationUpdate();
        }
    }

    public static interface Creator {
        public ValueAnimatorCompat createAnimator();
    }

    public static class AnimatorListenerAdapter
    implements AnimatorListener {
        @Override
        public void onAnimationStart(ValueAnimatorCompat animator) {
        }

        @Override
        public void onAnimationEnd(ValueAnimatorCompat animator) {
        }

        @Override
        public void onAnimationCancel(ValueAnimatorCompat animator) {
        }
    }

    public static interface AnimatorListener {
        public void onAnimationStart(ValueAnimatorCompat var1);

        public void onAnimationEnd(ValueAnimatorCompat var1);

        public void onAnimationCancel(ValueAnimatorCompat var1);
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(ValueAnimatorCompat var1);
    }
}

