/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.xmlreader;

import java.io.Serializable;
import org.quickserver.util.xmlreader.KeyStoreInfo;
import org.quickserver.util.xmlreader.TrustStoreInfo;

public class SecureStore
implements Serializable {
    private String type = "JKS";
    private String algorithm = "SunX509";
    private String provider = null;
    private KeyStoreInfo keyStoreInfo = null;
    private TrustStoreInfo trustStoreInfo = null;
    private String secureStoreManager = "org.quickserver.security.SecureStoreManager";

    public void setType(String type) {
        if (type != null && type.trim().length() != 0) {
            this.type = type;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setAlgorithm(String algorithm) {
        if (algorithm != null && algorithm.trim().length() != 0) {
            this.algorithm = algorithm;
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setProvider(String provider) {
        if (provider != null && provider.trim().length() != 0) {
            this.provider = provider;
        }
    }

    public String getProvider() {
        return this.provider;
    }

    public void setKeyStoreInfo(KeyStoreInfo keyStoreInfo) {
        if (keyStoreInfo != null) {
            this.keyStoreInfo = keyStoreInfo;
        }
    }

    public KeyStoreInfo getKeyStoreInfo() {
        return this.keyStoreInfo;
    }

    public void setTrustStoreInfo(TrustStoreInfo trustStoreInfo) {
        if (trustStoreInfo != null) {
            this.trustStoreInfo = trustStoreInfo;
        }
    }

    public TrustStoreInfo getTrustStoreInfo() {
        return this.trustStoreInfo;
    }

    public void setSecureStoreManager(String className) {
        if (className != null && className.trim().length() != 0) {
            this.secureStoreManager = className;
        }
    }

    public String getSecureStoreManager() {
        return this.secureStoreManager;
    }

    public String toXML(String pad) {
        if (pad == null) {
            pad = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(pad).append("<secure-store>\n");
        sb.append(pad).append("\t<type>").append(this.getType()).append("</type>\n");
        sb.append(pad).append("\t<algorithm>").append(this.getAlgorithm()).append("</algorithm>\n");
        if (this.getProvider() != null) {
            sb.append(pad).append("\t<provider>").append(this.getProvider()).append("</provider>\n");
        }
        if (this.getKeyStoreInfo() != null) {
            sb.append(this.getKeyStoreInfo().toXML(pad + "\t"));
        }
        if (this.getTrustStoreInfo() != null) {
            sb.append(this.getTrustStoreInfo().toXML(pad + "\t"));
        }
        sb.append(pad).append("\t<secure-store-manager>").append(this.getSecureStoreManager()).append("</secure-store-manager>\n");
        sb.append(pad).append("</secure-store>\n");
        return sb.toString();
    }
}

