/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.xmlreader;

import java.io.Serializable;
import org.quickserver.util.xmlreader.SecureStore;

public class Secure
implements Serializable {
    private boolean enable = false;
    private boolean load = false;
    private int port = -1;
    private String protocol = "TLS";
    private boolean clientAuthEnable = false;
    private SecureStore secureStore = new SecureStore();

    public void setEnable(boolean enable) {
        this.enable = enable;
        if (enable) {
            this.setLoad(true);
        }
    }

    public boolean getEnable() {
        return this.enable;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setLoad(boolean load) {
        this.load = load;
    }

    public boolean getLoad() {
        return this.load;
    }

    public boolean isLoad() {
        return this.load;
    }

    public void setPort(int port) {
        if (port >= 0) {
            this.port = port;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setProtocol(String protocol) {
        if (protocol != null && protocol.trim().length() != 0) {
            this.protocol = protocol;
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setClientAuthEnable(boolean enable) {
        this.clientAuthEnable = enable;
    }

    public boolean getClientAuthEnable() {
        return this.clientAuthEnable;
    }

    public boolean isClientAuthEnable() {
        return this.clientAuthEnable;
    }

    public void setSecureStore(SecureStore secureStore) {
        if (secureStore != null) {
            this.secureStore = secureStore;
        }
    }

    public SecureStore getSecureStore() {
        return this.secureStore;
    }

    public String toXML(String pad) {
        if (pad == null) {
            pad = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(pad + "<secure>\n");
        sb.append(pad + "\t<enable>" + this.getEnable() + "</enable>\n");
        sb.append(pad + "\t<load>" + this.getLoad() + "</load>\n");
        if (this.getPort() != -1) {
            sb.append(pad + "\t<port>" + this.getPort() + "</port>\n");
        }
        sb.append(pad + "\t<protocol>" + this.getProtocol() + "</protocol>\n");
        sb.append(pad + "\t<client-auth-enable>" + this.getClientAuthEnable() + "</client-auth-enable>\n");
        if (this.getSecureStore() != null) {
            sb.append(this.getSecureStore().toXML(pad + "\t"));
        }
        sb.append(pad + "</secure>\n");
        return sb.toString();
    }
}

