/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.xmlreader;

import org.quickserver.net.qsadmin.QSAdminServer;
import org.quickserver.util.xmlreader.BasicServerConfig;

public class QSAdminServerConfig
extends BasicServerConfig {
    private String commandPlugin;
    private String commandShellEnabled = "false";
    private String commandShellPromptName = "QSAdmin";

    public QSAdminServerConfig() {
        this.setName("QSAdminServer v " + QSAdminServer.getVersion());
        this.setPort(9877);
        this.setBindAddr("127.0.0.1");
        this.setClientCommandHandler("org.quickserver.net.qsadmin.CommandHandler");
        this.setClientEventHandler("org.quickserver.net.qsadmin.CommandHandler");
        this.setClientAuthenticationHandler("org.quickserver.net.qsadmin.Authenticator");
        this.setClientData("org.quickserver.net.qsadmin.Data");
        this.setMaxConnection(1L);
        this.getServerMode().setBlocking(true);
    }

    public void setCommandPlugin(String plugin) {
        if (plugin != null && !plugin.equals("")) {
            this.commandPlugin = plugin;
        }
    }

    public String getCommandPlugin() {
        return this.commandPlugin;
    }

    public void setCommandShellEnable(String enable) {
        if (enable != null && !enable.equals("")) {
            this.commandShellEnabled = enable;
        }
    }

    public String getCommandShellEnable() {
        return this.commandShellEnabled;
    }

    public void setCommandShellPromptName(String commandShellPromptName) {
        if (commandShellPromptName != null && !commandShellPromptName.equals("")) {
            this.commandShellPromptName = commandShellPromptName;
        }
    }

    public String getCommandShellPromptName() {
        return this.commandShellPromptName;
    }

    public String toXML(String pad) {
        if (pad == null) {
            pad = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(pad + "<qsadmin-server>\n");
        if (this.getName() != null) {
            sb.append(pad + "\t<name>" + this.getName() + "</name>\n");
        }
        if (this.getServerBanner() != null) {
            sb.append(pad + "\t<server-banner>" + this.getServerBanner() + "</server-banner>\n");
        }
        sb.append(pad + "\t<port>" + this.getPort() + "</port>\n");
        sb.append(pad + "\t<bind-address>" + this.getBindAddr() + "</bind-address>\n");
        sb.append(this.getServerMode().toXML(pad + "\t"));
        if (this.getClientEventHandler() != null) {
            sb.append(pad + "\t<client-event-handler>" + this.getClientEventHandler() + "</client-event-handler>\n");
        }
        if (this.getClientCommandHandler() != null) {
            sb.append(pad + "\t<client-command-handler>" + this.getClientCommandHandler() + "</client-command-handler>\n");
        }
        if (this.getClientObjectHandler() != null) {
            sb.append(pad + "\t<client-object-handler>" + this.getClientObjectHandler() + "</client-object-handler>\n");
        }
        if (this.getClientBinaryHandler() != null) {
            sb.append(pad + "\t<client-binary-handler>" + this.getClientBinaryHandler() + "</client-binary-handler>\n");
        }
        if (this.getClientWriteHandler() != null) {
            sb.append(pad + "\t<client-write-handler>" + this.getClientWriteHandler() + "</client-write-handler>\n");
        }
        if (this.getClientAuthenticationHandler() != null) {
            sb.append(pad + "\t<client-authentication-handler>" + this.getClientAuthenticationHandler() + "</client-authentication-handler>\n");
        } else if (this.getAuthenticator() != null) {
            sb.append(pad + "\t<authenticator>" + this.getAuthenticator() + "</authenticator>\n");
        }
        if (this.getClientData() != null) {
            sb.append(pad + "\t<client-data>" + this.getClientData() + "</client-data>\n");
        }
        if (this.getClientExtendedEventHandler() != null) {
            sb.append(pad + "\t<client-extended-event-handler>" + this.getClientExtendedEventHandler() + "</client-extended-event-handler>\n");
        }
        sb.append(pad + "\t<timeout>" + this.getTimeout() + "</timeout>\n");
        if (this.getTimeoutMsg() != null) {
            sb.append(pad + "\t<timeout-msg>" + this.getTimeoutMsg() + "</timeout-msg>\n");
        }
        sb.append(pad + "\t<max-auth-try>" + this.getMaxAuthTry() + "</max-auth-try>\n");
        if (this.getMaxAuthTryMsg() != null) {
            sb.append(pad + "\t<max-auth-try-msg>" + this.getMaxAuthTryMsg() + "</max-auth-try-msg>\n");
        }
        sb.append(pad + "\t<max-connection>" + this.getMaxConnection() + "</max-connection>\n");
        if (this.getMaxConnectionMsg() != null) {
            sb.append(pad + "\t<max-connection-msg>" + this.getMaxConnectionMsg() + "</max-connection-msg>\n");
        }
        sb.append(this.getObjectPoolConfig().toXML(pad + "\t"));
        sb.append(pad).append("\t<communication-logging>\n");
        sb.append(pad).append("\t\t<enable>").append(this.getCommunicationLogging()).append("</enable>\n");
        sb.append(pad).append("\t</communication-logging>\n");
        if (this.getCommandPlugin() != null) {
            sb.append(pad).append("\t<command-plugin>").append(this.getCommandPlugin()).append("</command-plugin>\n");
        }
        sb.append(pad).append("\t<command-shell>\n");
        sb.append(pad).append("\t\t<enable>").append(this.getCommandShellEnable()).append("</enable>\n");
        sb.append(pad).append("\t\t<prompt-name>").append(this.getCommandShellPromptName()).append("</prompt-name>\n");
        sb.append(pad + "\t</command-shell>\n");
        if (this.getAccessConstraintConfig() != null) {
            sb.append(this.getAccessConstraintConfig().toXML(pad + "\t"));
        }
        if (this.getServerHooks() != null) {
            sb.append(this.getServerHooks().toXML(pad + "\t"));
        }
        sb.append(this.getSecure().toXML(pad + "\t"));
        sb.append(this.getAdvancedSettings().toXML(pad + "\t"));
        sb.append(pad).append("</qsadmin-server>\n");
        return sb.toString();
    }

    public String toString() {
        return this.toXML(null);
    }
}

