/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.xmlreader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class IpFilterConfig
implements Serializable {
    private ArrayList ipCollection = new ArrayList();
    private boolean enable = false;
    private boolean allowAccess = false;

    public void addClientIpAddress(String clientIpAddress) {
        if (clientIpAddress != null) {
            this.ipCollection.add(clientIpAddress);
        }
    }

    public ArrayList getIpCollection() {
        return this.ipCollection;
    }

    public Iterator iterator() {
        return this.ipCollection.iterator();
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void setAllowAccess(boolean enable) {
        this.allowAccess = enable;
    }

    public boolean getAllowAccess() {
        return this.allowAccess;
    }

    public String toXML(String pad) {
        if (pad == null) {
            pad = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(pad).append("<ip-filter>\n");
        sb.append(pad).append("\t<enable>").append(this.getEnable()).append("</enable>\n");
        sb.append(pad).append("\t<allow-access>").append(this.getAllowAccess()).append("</allow-access>\n");
        sb.append(pad).append("\t<ip-collection>\n");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            String cip = (String)iterator.next();
            sb.append(pad).append("\t\t<client-ip-address>").append(cip).append("</client-ip-address>\n");
        }
        sb.append(pad).append("\t</ip-collection>\n");
        sb.append(pad).append("</ip-filter>\n");
        return sb.toString();
    }
}

