/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.xmlreader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.digester3.Digester;
import org.quickserver.net.server.QuickServer;
import org.quickserver.swing.SensitiveInput;
import org.quickserver.util.io.PasswordField;
import org.quickserver.util.xmlreader.AccessConstraintConfig;
import org.quickserver.util.xmlreader.AdvancedSettings;
import org.quickserver.util.xmlreader.ApplicationConfiguration;
import org.quickserver.util.xmlreader.ByteBufferObjectPoolConfig;
import org.quickserver.util.xmlreader.ClientDataObjectPoolConfig;
import org.quickserver.util.xmlreader.ClientHandlerObjectPoolConfig;
import org.quickserver.util.xmlreader.DBObjectPoolConfig;
import org.quickserver.util.xmlreader.DatabaseConnectionConfig;
import org.quickserver.util.xmlreader.DatabaseConnectionSet;
import org.quickserver.util.xmlreader.DefaultDataMode;
import org.quickserver.util.xmlreader.InitServerHooks;
import org.quickserver.util.xmlreader.IpFilterConfig;
import org.quickserver.util.xmlreader.KeyStoreInfo;
import org.quickserver.util.xmlreader.ObjectPoolConfig;
import org.quickserver.util.xmlreader.Property;
import org.quickserver.util.xmlreader.QSAdminServerConfig;
import org.quickserver.util.xmlreader.QuickServerConfig;
import org.quickserver.util.xmlreader.Secure;
import org.quickserver.util.xmlreader.SecureStore;
import org.quickserver.util.xmlreader.ServerHooks;
import org.quickserver.util.xmlreader.ServerMode;
import org.quickserver.util.xmlreader.ThreadObjectPoolConfig;
import org.quickserver.util.xmlreader.TrustStoreInfo;

public class ConfigReader {
    private static Logger logger = Logger.getLogger(ConfigReader.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuickServerConfig read(String fileName) throws Exception {
        QuickServerConfig quickServerConfig;
        block2: {
            File configFile = new File(fileName);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(configFile);
                logger.log(Level.FINE, "Loading config from xml file : {0}", configFile.getAbsolutePath());
                quickServerConfig = ConfigReader.read(fis, configFile.getAbsolutePath());
                Object var5_4 = null;
                if (fis == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (fis == null) break block3;
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
        }
        return quickServerConfig;
    }

    public static QuickServerConfig read(InputStream input, String config_file_location) throws Exception {
        Digester digester = new Digester();
        digester.setValidating(false);
        String mainTag = "quickserver";
        String subTag = "";
        digester.addObjectCreate(mainTag, QuickServerConfig.class);
        digester.addBeanPropertySetter(mainTag + "/name", "name");
        digester.addBeanPropertySetter(mainTag + "/server-banner", "serverBanner");
        digester.addBeanPropertySetter(mainTag + "/port", "port");
        digester.addBeanPropertySetter(mainTag + "/bind-address", "bindAddr");
        String curTag = mainTag + "/server-mode";
        digester.addObjectCreate(curTag, ServerMode.class);
        digester.addBeanPropertySetter(curTag + "/blocking", "blocking");
        digester.addSetNext(curTag, "setServerMode");
        digester.addBeanPropertySetter(mainTag + "/client-event-handler", "clientEventHandler");
        digester.addBeanPropertySetter(mainTag + "/client-command-handler", "clientCommandHandler");
        digester.addBeanPropertySetter(mainTag + "/client-object-handler", "clientObjectHandler");
        digester.addBeanPropertySetter(mainTag + "/client-binary-handler", "clientBinaryHandler");
        digester.addBeanPropertySetter(mainTag + "/client-write-handler", "clientWriteHandler");
        digester.addBeanPropertySetter(mainTag + "/authenticator", "authenticator");
        digester.addBeanPropertySetter(mainTag + "/client-authentication-handler", "clientAuthenticationHandler");
        digester.addBeanPropertySetter(mainTag + "/client-data", "clientData");
        digester.addBeanPropertySetter(mainTag + "/client-extended-event-handler", "clientExtendedEventHandler");
        digester.addBeanPropertySetter(mainTag + "/timeout", "timeout");
        digester.addBeanPropertySetter(mainTag + "/timeout-msg", "timeoutMsg");
        digester.addBeanPropertySetter(mainTag + "/max-auth-try", "maxAuthTry");
        digester.addBeanPropertySetter(mainTag + "/max-auth-try-msg", "maxAuthTryMsg");
        digester.addBeanPropertySetter(mainTag + "/max-connection", "maxConnection");
        digester.addBeanPropertySetter(mainTag + "/max-connection-msg", "maxConnectionMsg");
        digester.addBeanPropertySetter(mainTag + "/console-logging-level", "consoleLoggingLevel");
        digester.addBeanPropertySetter(mainTag + "/console-logging-formatter", "consoleLoggingFormatter");
        curTag = mainTag + "/default-data-mode";
        digester.addObjectCreate(curTag, DefaultDataMode.class);
        digester.addBeanPropertySetter(curTag + "/data-type-in", "dataModeIn");
        digester.addBeanPropertySetter(curTag + "/data-type-out", "dataModeOut");
        digester.addSetNext(curTag, "setDefaultDataMode");
        curTag = mainTag + "/object-pool";
        digester.addObjectCreate(curTag, ObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/init-size", "initSize");
        digester.addBeanPropertySetter(curTag + "/pool-manager", "poolManager");
        digester.addObjectCreate(curTag + "/thread-object-pool", ThreadObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/thread-object-pool/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/thread-object-pool/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/thread-object-pool/init-size", "initSize");
        digester.addSetNext(curTag + "/thread-object-pool", "setThreadObjectPoolConfig");
        digester.addObjectCreate(curTag + "/client-handler-object-pool", ClientHandlerObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/client-handler-object-pool/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/client-handler-object-pool/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/client-handler-object-pool/init-size", "initSize");
        digester.addSetNext(curTag + "/client-handler-object-pool", "setClientHandlerObjectPoolConfig");
        digester.addObjectCreate(curTag + "/byte-buffer-object-pool", ByteBufferObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/byte-buffer-object-pool/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/byte-buffer-object-pool/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/byte-buffer-object-pool/init-size", "initSize");
        digester.addSetNext(curTag + "/byte-buffer-object-pool", "setByteBufferObjectPoolConfig");
        digester.addObjectCreate(curTag + "/client-data-object-pool", ClientDataObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/client-data-object-pool/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/client-data-object-pool/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/client-data-object-pool/init-size", "initSize");
        digester.addSetNext(curTag + "/client-data-object-pool", "setClientDataObjectPoolConfig");
        digester.addSetNext(curTag, "setObjectPoolConfig");
        digester.addBeanPropertySetter(mainTag + "/communication-logging/enable", "communicationLogging");
        digester.addBeanPropertySetter(mainTag + "/security-manager-class", "securityManagerClass");
        digester.addObjectCreate(mainTag + "/access-constraint", AccessConstraintConfig.class);
        digester.addObjectCreate(mainTag + "/access-constraint/ip-filter", IpFilterConfig.class);
        digester.addBeanPropertySetter(mainTag + "/access-constraint/ip-filter/enable", "enable");
        digester.addBeanPropertySetter(mainTag + "/access-constraint/ip-filter/allow-access", "allowAccess");
        digester.addCallMethod(mainTag + "/access-constraint/ip-filter/ip-collection/client-ip-address", "addClientIpAddress", 0);
        digester.addSetNext(mainTag + "/access-constraint/ip-filter", "setIpFilterConfig");
        digester.addSetNext(mainTag + "/access-constraint", "setAccessConstraintConfig");
        digester.addBeanPropertySetter(mainTag + "/application-jar-path", "applicationJarPath");
        digester.addObjectCreate(mainTag + "/server-hooks", ServerHooks.class);
        digester.addCallMethod(mainTag + "/server-hooks/class-name", "addClassName", 0);
        digester.addSetNext(mainTag + "/server-hooks", "setServerHooks");
        curTag = mainTag + "/secure";
        digester.addObjectCreate(curTag, Secure.class);
        digester.addBeanPropertySetter(curTag + "/enable", "enable");
        digester.addBeanPropertySetter(curTag + "/load", "load");
        digester.addBeanPropertySetter(curTag + "/port", "port");
        digester.addBeanPropertySetter(curTag + "/protocol", "protocol");
        digester.addBeanPropertySetter(curTag + "/client-auth-enable", "clientAuthEnable");
        digester.addObjectCreate(curTag + "/secure-store", SecureStore.class);
        digester.addBeanPropertySetter(curTag + "/secure-store/type", "type");
        digester.addBeanPropertySetter(curTag + "/secure-store/algorithm", "algorithm");
        digester.addBeanPropertySetter(curTag + "/secure-store/provider", "provider");
        digester.addObjectCreate(curTag + "/secure-store/key-store-info", KeyStoreInfo.class);
        digester.addBeanPropertySetter(curTag + "/secure-store/key-store-info/store-file", "storeFile");
        digester.addBeanPropertySetter(curTag + "/secure-store/key-store-info/store-password", "storePassword");
        digester.addBeanPropertySetter(curTag + "/secure-store/key-store-info/key-password", "keyPassword");
        digester.addSetNext(curTag + "/secure-store/key-store-info", "setKeyStoreInfo");
        digester.addObjectCreate(curTag + "/secure-store/trust-store-info", TrustStoreInfo.class);
        digester.addBeanPropertySetter(curTag + "/secure-store/trust-store-info/store-file", "storeFile");
        digester.addBeanPropertySetter(curTag + "/secure-store/trust-store-info/store-password", "storePassword");
        digester.addBeanPropertySetter(curTag + "/secure-store/trust-store-info/type", "type");
        digester.addBeanPropertySetter(curTag + "/secure-store/trust-store-info/provider", "provider");
        digester.addSetNext(curTag + "/secure-store/trust-store-info", "setTrustStoreInfo");
        digester.addBeanPropertySetter(curTag + "/secure-store/secure-store-manager", "secureStoreManager");
        digester.addSetNext(curTag + "/secure-store", "setSecureStore");
        digester.addSetNext(curTag, "setSecure");
        curTag = mainTag + "/advanced-settings";
        digester.addObjectCreate(curTag, AdvancedSettings.class);
        digester.addBeanPropertySetter(curTag + "/charset", "charset");
        digester.addBeanPropertySetter(curTag + "/byte-buffer-size", "byteBufferSize");
        digester.addBeanPropertySetter(curTag + "/backlog", "backlog");
        digester.addBeanPropertySetter(curTag + "/use-direct-byte-buffer", "useDirectByteBuffer");
        digester.addBeanPropertySetter(curTag + "/socket-linger", "socketLinger");
        digester.addBeanPropertySetter(curTag + "/debug-non-blocking-mode", "debugNonBlockingMode");
        digester.addBeanPropertySetter(curTag + "/client-identifier", "clientIdentifier");
        digester.addBeanPropertySetter(curTag + "/qsobject-pool-maker", "qsObjectPoolMaker");
        digester.addBeanPropertySetter(curTag + "/max-threads-for-nio-write", "maxThreadsForNioWrite");
        digester.addBeanPropertySetter(curTag + "/performance-preferences-connection-time", "performancePreferencesConnectionTime");
        digester.addBeanPropertySetter(curTag + "/performance-preferences-latency", "performancePreferencesLatency");
        digester.addBeanPropertySetter(curTag + "/performance-preferences-bandwidth", "performancePreferencesBandwidth");
        digester.addBeanPropertySetter(curTag + "/client-socket-tcp-no-delay", "clientSocketTcpNoDelay");
        digester.addBeanPropertySetter(curTag + "/client-socket-traffic-class", "clientSocketTrafficClass");
        digester.addBeanPropertySetter(curTag + "/client-socket-receive-buffer-size", "clientSocketReceiveBufferSize");
        digester.addBeanPropertySetter(curTag + "/client-socket-send-buffer-size", "clientSocketSendBufferSize");
        digester.addSetNext(curTag, "setAdvancedSettings");
        subTag = "qsadmin-server";
        curTag = mainTag + "/" + subTag;
        digester.addObjectCreate(curTag, QSAdminServerConfig.class);
        digester.addBeanPropertySetter(curTag + "/name", "name");
        digester.addBeanPropertySetter(curTag + "/server-banner", "serverBanner");
        digester.addBeanPropertySetter(curTag + "/port", "port");
        digester.addObjectCreate(curTag + "/server-mode", ServerMode.class);
        digester.addBeanPropertySetter(curTag + "/server-mode/blocking", "blocking");
        digester.addSetNext(curTag + "/server-mode", "setServerMode");
        digester.addBeanPropertySetter(curTag + "/client-event-handler", "clientEventHandler");
        digester.addBeanPropertySetter(curTag + "/client-command-handler", "clientCommandHandler");
        digester.addBeanPropertySetter(curTag + "/client-object-handler", "clientObjectHandler");
        digester.addBeanPropertySetter(curTag + "/client-binary-handler", "clientBinaryHandler");
        digester.addBeanPropertySetter(curTag + "/client-write-handler", "clientWriteHandler");
        digester.addBeanPropertySetter(curTag + "/authenticator", "authenticator");
        digester.addBeanPropertySetter(curTag + "/client-authentication-handler", "clientAuthenticationHandler");
        digester.addBeanPropertySetter(curTag + "/client-data", "clientData");
        digester.addBeanPropertySetter(curTag + "/client-extended-event-handler", "clientExtendedEventHandler");
        digester.addBeanPropertySetter(curTag + "/timeout", "timeout");
        digester.addBeanPropertySetter(curTag + "/max-auth-try", "maxAuthTry");
        digester.addBeanPropertySetter(curTag + "/max-auth-try-msg", "maxAuthTryMsg");
        digester.addBeanPropertySetter(curTag + "/timeout-msg", "timeoutMsg");
        digester.addBeanPropertySetter(curTag + "/max-connection", "maxConnection");
        digester.addBeanPropertySetter(curTag + "/max-connection-msg", "maxConnectionMsg");
        digester.addBeanPropertySetter(curTag + "/bind-address", "bindAddr");
        digester.addBeanPropertySetter(curTag + "/client-object-handler", "clientObjectHandler");
        digester.addBeanPropertySetter(curTag + "/console-logging-level", "consoleLoggingLevel");
        digester.addBeanPropertySetter(curTag + "/console-logging-formatter", "consoleLoggingFormatter");
        digester.addObjectCreate(curTag + "/default-data-mode", DefaultDataMode.class);
        digester.addBeanPropertySetter(curTag + "/default-data-mode/data-type-in", "dataModeIn");
        digester.addBeanPropertySetter(curTag + "/default-data-mode/data-type-out", "dataModeOut");
        digester.addSetNext(curTag + "/default-data-mode", "setDefaultDataMode");
        digester.addObjectCreate(curTag + "/object-pool", ObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/object-pool/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/object-pool/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/object-pool/init-size", "initSize");
        digester.addBeanPropertySetter(curTag + "/object-pool/pool-manager", "poolManager");
        digester.addObjectCreate(curTag + "/object-pool/thread-object-pool", ThreadObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/object-pool/thread-object-pool/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/object-pool/thread-object-pool/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/object-pool/thread-object-pool/init-size", "initSize");
        digester.addSetNext(curTag + "/object-pool/thread-object-pool", "setThreadObjectPoolConfig");
        digester.addObjectCreate(curTag + "/object-pool/client-handler-object-pool", ClientHandlerObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/object-pool/client-handler-object-pool/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/object-pool/client-handler-object-pool/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/object-pool/client-handler-object-pool/init-size", "initSize");
        digester.addSetNext(curTag + "/object-pool/client-handler-object-pool", "setClientHandlerObjectPoolConfig");
        digester.addObjectCreate(curTag + "/object-pool/byte-buffer-object-pool", ByteBufferObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/object-pool/byte-buffer-object-pool/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/object-pool/byte-buffer-object-pool/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/object-pool/byte-buffer-object-pool/init-size", "initSize");
        digester.addSetNext(curTag + "/object-pool/byte-buffer-object-pool", "setByteBufferObjectPoolConfig");
        digester.addObjectCreate(curTag + "/object-pool/client-data-object-pool", ClientDataObjectPoolConfig.class);
        digester.addBeanPropertySetter(curTag + "/object-pool/client-data-object-pool/max-active", "maxActive");
        digester.addBeanPropertySetter(curTag + "/object-pool/client-data-object-pool/max-idle", "maxIdle");
        digester.addBeanPropertySetter(curTag + "/object-pool/client-data-object-pool/init-size", "initSize");
        digester.addSetNext(curTag + "/object-pool/client-data-object-pool", "setClientDataObjectPoolConfig");
        digester.addSetNext(curTag + "/object-pool", "setObjectPoolConfig");
        digester.addBeanPropertySetter(curTag + "/command-shell/enable", "commandShellEnable");
        digester.addBeanPropertySetter(curTag + "/command-shell/prompt-name", "commandShellPromptName");
        digester.addBeanPropertySetter(curTag + "/communication-logging/enable", "communicationLogging");
        digester.addObjectCreate(curTag + "/access-constraint", AccessConstraintConfig.class);
        digester.addObjectCreate(curTag + "/access-constraint/ip-filter", IpFilterConfig.class);
        digester.addBeanPropertySetter(curTag + "/access-constraint/ip-filter/enable", "enable");
        digester.addBeanPropertySetter(curTag + "/access-constraint/ip-filter/allow-access", "allowAccess");
        digester.addCallMethod(curTag + "/access-constraint/ip-filter/ip-collection/client-ip-address", "addClientIpAddress", 0);
        digester.addSetNext(curTag + "/access-constraint/ip-filter", "setIpFilterConfig");
        digester.addSetNext(curTag + "/access-constraint", "setAccessConstraintConfig");
        digester.addObjectCreate(curTag + "/server-hooks", ServerHooks.class);
        digester.addCallMethod(curTag + "/server-hooks/class-name", "addClassName", 0);
        digester.addSetNext(curTag + "/server-hooks", "setServerHooks");
        digester.addObjectCreate(curTag + "/secure", Secure.class);
        digester.addBeanPropertySetter(curTag + "/secure/enable", "enable");
        digester.addBeanPropertySetter(curTag + "/secure/load", "load");
        digester.addBeanPropertySetter(curTag + "/secure/port", "port");
        digester.addBeanPropertySetter(curTag + "/secure/protocol", "protocol");
        digester.addBeanPropertySetter(curTag + "/secure/client-auth-enable", "clientAuthEnable");
        digester.addObjectCreate(curTag + "/secure/secure-store", SecureStore.class);
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/type", "type");
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/algorithm", "algorithm");
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/provider", "provider");
        digester.addObjectCreate(curTag + "/secure/secure-store/key-store-info", KeyStoreInfo.class);
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/key-store-info/store-file", "storeFile");
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/key-store-info/store-password", "storePassword");
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/key-store-info/key-password", "keyPassword");
        digester.addSetNext(curTag + "/secure/secure-store/key-store-info", "setKeyStoreInfo");
        digester.addObjectCreate(curTag + "/secure/secure-store/trust-store-info", TrustStoreInfo.class);
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/trust-store-info/store-file", "storeFile");
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/trust-store-info/store-password", "storePassword");
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/trust-store-info/type", "type");
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/trust-store-info/provider", "provider");
        digester.addSetNext(curTag + "/secure/secure-store/trust-store-info", "setTrustStoreInfo");
        digester.addBeanPropertySetter(curTag + "/secure/secure-store/secure-store-manager", "secureStoreManager");
        digester.addSetNext(curTag + "/secure/secure-store", "setSecureStore");
        digester.addSetNext(curTag + "/secure", "setSecure");
        digester.addBeanPropertySetter(curTag + "/command-plugin", "commandPlugin");
        digester.addObjectCreate(curTag + "/advanced-settings", AdvancedSettings.class);
        digester.addBeanPropertySetter(curTag + "/advanced-settings/charset", "charset");
        digester.addBeanPropertySetter(curTag + "/advanced-settings/byte-buffer-size", "byteBufferSize");
        digester.addBeanPropertySetter(curTag + "/advanced-settings/backlog", "backlog");
        digester.addBeanPropertySetter(curTag + "/advanced-settings/use-direct-byte-buffer", "useDirectByteBuffer");
        digester.addBeanPropertySetter(curTag + "/advanced-settings/socket-linger", "socketLinger");
        digester.addBeanPropertySetter(curTag + "/advanced-settings/debug-non-blocking-mode", "debugNonBlockingMode");
        digester.addBeanPropertySetter(curTag + "/advanced-settings/client-identifier", "clientIdentifier");
        digester.addBeanPropertySetter(curTag + "/advanced-settings/qsobject-pool-maker", "qsObjectPoolMaker");
        digester.addBeanPropertySetter(curTag + "/advanced-settings/max-threads-for-nio-write", "maxThreadsForNioWrite");
        digester.addSetNext(curTag + "/advanced-settings", "setAdvancedSettings");
        digester.addSetNext(curTag, "setQSAdminServerConfig");
        subTag = "db-object-pool";
        digester.addObjectCreate(mainTag + "/" + subTag, DBObjectPoolConfig.class);
        digester.addObjectCreate(mainTag + "/" + subTag + "/database-connection-set", DatabaseConnectionSet.class);
        curTag = mainTag + "/" + subTag + "/database-connection-set/database-connection";
        digester.addObjectCreate(curTag, DatabaseConnectionConfig.class);
        digester.addBeanPropertySetter(curTag + "/id", "id");
        digester.addBeanPropertySetter(curTag + "/driver", "driver");
        digester.addBeanPropertySetter(curTag + "/url", "url");
        digester.addBeanPropertySetter(curTag + "/username", "username");
        digester.addBeanPropertySetter(curTag + "/password", "password");
        digester.addSetNext(curTag, "addDatabaseConnection");
        digester.addSetNext(mainTag + "/" + subTag + "/database-connection-set", "setDatabaseConnectionSet");
        curTag = mainTag + "/" + subTag + "/db-pool-util";
        digester.addBeanPropertySetter(curTag, "dbPoolUtil");
        digester.addSetNext(mainTag + "/" + subTag, "setDBObjectPoolConfig");
        subTag = "application-configuration";
        digester.addObjectCreate(mainTag + "/" + subTag, ApplicationConfiguration.class);
        digester.addBeanPropertySetter(mainTag + "/" + subTag + "/prompt-type", "promptType");
        curTag = mainTag + "/" + subTag + "/property";
        digester.addObjectCreate(curTag, Property.class);
        digester.addBeanPropertySetter(curTag + "/property-name", "name");
        digester.addBeanPropertySetter(curTag + "/property-value", "value");
        digester.addSetNext(curTag, "addProperty");
        digester.addSetNext(mainTag + "/" + subTag, "setApplicationConfiguration");
        subTag = "init-server-hooks";
        digester.addObjectCreate(mainTag + "/" + subTag, InitServerHooks.class);
        digester.addCallMethod(mainTag + "/" + subTag + "/class-name", "addClassName", 0);
        digester.addSetNext(mainTag + "/" + subTag, "setInitServerHooks");
        QuickServerConfig qsc = (QuickServerConfig)digester.parse(input);
        qsc.setConfigFile(config_file_location);
        ConfigReader.loadMissingApplicationConfiguration(qsc);
        QuickServer.setDebugNonBlockingMode(qsc.getAdvancedSettings().getDebugNonBlockingMode());
        return qsc;
    }

    private static void loadMissingApplicationConfiguration(QuickServerConfig qsc) throws IOException {
        boolean guiPrompt;
        ApplicationConfiguration ac = qsc.getApplicationConfiguration();
        if (ac == null) {
            return;
        }
        Set propertyNames = ac.keySet();
        Iterator iterator = propertyNames.iterator();
        String key = null;
        String value = null;
        char[] sv = null;
        SensitiveInput sensitiveInput = null;
        boolean bl = guiPrompt = !ac.getPromptType().equals("console");
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            value = (String)ac.get(key);
            if (value != null) continue;
            if (guiPrompt && sensitiveInput == null) {
                sensitiveInput = new SensitiveInput(qsc.getName() + " - Input Prompt");
            }
            if ((sv = guiPrompt ? sensitiveInput.getInput(key) : PasswordField.getPassword("Input property value for " + key + " : ")) != null) {
                value = new String(sv);
                ac.put(key, value);
            }
            value = null;
        }
    }

    public static File makeAbsoluteToConfig(String fileName, QuickServerConfig config) {
        File file = new File(fileName);
        if (config == null) {
            return file;
        }
        if (!file.isAbsolute()) {
            String temp = config.getConfigFile();
            if (temp == null) {
                return file;
            }
            file = new File(temp);
            temp = file.getParent() + File.separatorChar + fileName;
            file = new File(temp);
        }
        return file;
    }
}

