/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.xmlreader;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class AdvancedSettings
implements Serializable {
    private String charset = "ISO-8859-1";
    private int byteBufferSize = 65536;
    private int backlog = 0;
    private boolean useDirectByteBuffer = true;
    private int socketLinger = -1;
    private boolean debugNonBlockingMode;
    private String clientIdentifierClass = "org.quickserver.net.server.impl.OptimisticClientIdentifier";
    private String qsObjectPoolMakerClass = null;
    private int maxThreadsForNioWrite = 10;
    private int performancePreferencesConnectionTime = 0;
    private int performancePreferencesLatency = 0;
    private int performancePreferencesBandwidth = 0;
    private boolean clientSocketTcpNoDelay = false;
    private String clientSocketTrafficClass;
    private int clientSocketReceiveBufferSize;
    private int clientSocketSendBufferSize;

    public void setCharset(String charset) {
        if (charset == null || charset.trim().length() == 0) {
            return;
        }
        if (!Charset.isSupported(charset)) {
            throw new UnsupportedCharsetException(charset);
        }
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setByteBufferSize(int byteBufferSize) {
        if (byteBufferSize > 0) {
            this.byteBufferSize = byteBufferSize;
        }
    }

    public int getByteBufferSize() {
        return this.byteBufferSize;
    }

    public void setBacklog(int backlog) {
        if (backlog >= 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setUseDirectByteBuffer(boolean flag) {
        this.useDirectByteBuffer = flag;
    }

    public boolean getUseDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public void setSocketLinger(int socketLinger) {
        this.socketLinger = socketLinger;
    }

    public int getSocketLinger() {
        return this.socketLinger;
    }

    public void setDebugNonBlockingMode(boolean debugNonBlockingMode) {
        this.debugNonBlockingMode = debugNonBlockingMode;
    }

    public boolean getDebugNonBlockingMode() {
        return this.debugNonBlockingMode;
    }

    public void setClientIdentifier(String clientIdentifierClass) {
        if (clientIdentifierClass == null || clientIdentifierClass.trim().length() == 0) {
            return;
        }
        this.clientIdentifierClass = clientIdentifierClass;
    }

    public String getClientIdentifier() {
        return this.clientIdentifierClass;
    }

    public void setQsObjectPoolMaker(String qsObjectPoolMakerClass) {
        this.qsObjectPoolMakerClass = qsObjectPoolMakerClass;
    }

    public String getQsObjectPoolMaker() {
        if (this.qsObjectPoolMakerClass == null) {
            this.qsObjectPoolMakerClass = "org.quickserver.util.pool.MakeQSObjectPool";
        }
        return this.qsObjectPoolMakerClass;
    }

    public void setMaxThreadsForNioWrite(int maxThreadsForNioWrite) {
        this.maxThreadsForNioWrite = maxThreadsForNioWrite;
    }

    public int getMaxThreadsForNioWrite() {
        return this.maxThreadsForNioWrite;
    }

    public String toXML(String pad) {
        if (pad == null) {
            pad = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(pad).append("<advanced-settings>\n");
        sb.append(pad + "\t<charset>").append(this.getCharset()).append("</charset>\n");
        sb.append(pad).append("\t<use-direct-byte-buffer>").append(this.getUseDirectByteBuffer()).append("</use-direct-byte-buffer>\n");
        sb.append(pad).append("\t<byte-buffer-size>").append(this.getByteBufferSize()).append("</byte-buffer-size>\n");
        sb.append(pad).append("\t<backlog>").append(this.getBacklog()).append("</backlog>\n");
        sb.append(pad).append("\t<socket-linger>").append(this.getSocketLinger()).append("</socket-linger>\n");
        sb.append(pad).append("\t<debug-non-blocking-mode>").append(this.getDebugNonBlockingMode()).append("</debug-non-blocking-mode>\n");
        sb.append(pad).append("\t<client-identifier>").append(this.getClientIdentifier()).append("</client-identifier>\n");
        sb.append(pad).append("\t<qsobject-pool-maker>").append(this.getQsObjectPoolMaker()).append("</qsobject-pool-maker>\n");
        sb.append(pad).append("\t<max-threads-for-nio-write>").append(this.getMaxThreadsForNioWrite()).append("</max-threads-for-nio-write>\n");
        sb.append(pad).append("\t<performance-preferences-connection-time>").append(this.getPerformancePreferencesConnectionTime()).append("</performance-preferences-connection-time>\n");
        sb.append(pad).append("\t<performance-preferences-latency>").append(this.getPerformancePreferencesLatency()).append("</performance-preferences-latency>\n");
        sb.append(pad).append("\t<performance-preferences-bandwidth>").append(this.getPerformancePreferencesBandwidth()).append("</performance-preferences-bandwidth>\n");
        sb.append(pad).append("\t<client-socket-tcp-no-delay>").append(this.getClientSocketTcpNoDelay()).append("</client-socket-tcp-no-delay>\n");
        if (this.getClientSocketTrafficClass() != null) {
            sb.append(pad).append("\t<client-socket-traffic-class>").append(this.getClientSocketTrafficClass()).append("</client-socket-traffic-class>\n");
        }
        if (this.getClientSocketReceiveBufferSize() != 0) {
            sb.append(pad).append("\t<client-socket-receive-buffer-size>").append(this.getClientSocketReceiveBufferSize()).append("</client-socket-receive-buffer-size>\n");
        }
        if (this.getClientSocketSendBufferSize() != 0) {
            sb.append(pad).append("\t<client-socket-send-buffer-size>").append(this.getClientSocketSendBufferSize()).append("</client-socket-send-buffer-size>\n");
        }
        sb.append(pad).append("</advanced-settings>\n");
        return sb.toString();
    }

    public int getPerformancePreferencesConnectionTime() {
        return this.performancePreferencesConnectionTime;
    }

    public void setPerformancePreferencesConnectionTime(int performancePreferencesConnectionTime) {
        this.performancePreferencesConnectionTime = performancePreferencesConnectionTime;
    }

    public int getPerformancePreferencesLatency() {
        return this.performancePreferencesLatency;
    }

    public void setPerformancePreferencesLatency(int performancePreferencesLatency) {
        this.performancePreferencesLatency = performancePreferencesLatency;
    }

    public int getPerformancePreferencesBandwidth() {
        return this.performancePreferencesBandwidth;
    }

    public void setPerformancePreferencesBandwidth(int performancePreferencesBandwidth) {
        this.performancePreferencesBandwidth = performancePreferencesBandwidth;
    }

    public boolean getClientSocketTcpNoDelay() {
        return this.clientSocketTcpNoDelay;
    }

    public void setClientSocketTcpNoDelay(boolean clientSocketTcpNoDelay) {
        this.clientSocketTcpNoDelay = clientSocketTcpNoDelay;
    }

    public String getClientSocketTrafficClass() {
        return this.clientSocketTrafficClass;
    }

    public void setClientSocketTrafficClass(String clientSocketTrafficClass) {
        this.clientSocketTrafficClass = clientSocketTrafficClass;
    }

    public int getClientSocketReceiveBufferSize() {
        return this.clientSocketReceiveBufferSize;
    }

    public void setClientSocketReceiveBufferSize(int clientSocketReceiveBufferSize) {
        this.clientSocketReceiveBufferSize = clientSocketReceiveBufferSize;
    }

    public int getClientSocketSendBufferSize() {
        return this.clientSocketSendBufferSize;
    }

    public void setClientSocketSendBufferSize(int clientSocketSendBufferSize) {
        this.clientSocketSendBufferSize = clientSocketSendBufferSize;
    }
}

