/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.pool;

import java.nio.ByteBuffer;
import org.apache.commons.pool.BasePoolableObjectFactory;

public class ByteBufferObjectFactory
extends BasePoolableObjectFactory {
    int bufferSize = -1;
    boolean useDirectByteBuffer = true;

    public ByteBufferObjectFactory(int bufferSize, boolean useDirectByteBuffer) {
        this.bufferSize = bufferSize;
        this.useDirectByteBuffer = useDirectByteBuffer;
    }

    public Object makeObject() {
        if (this.useDirectByteBuffer) {
            return ByteBuffer.allocateDirect(this.bufferSize);
        }
        return ByteBuffer.allocate(this.bufferSize);
    }

    public void passivateObject(Object obj) {
        ByteBuffer ch = (ByteBuffer)obj;
        ch.clear();
    }

    public void activateObject(Object obj) {
    }

    public void destroyObject(Object obj) {
        if (obj == null) {
            return;
        }
        this.passivateObject(obj);
        obj = null;
    }

    public boolean validateObject(Object obj) {
        return obj != null;
    }
}

