/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.pool;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.PoolableObjectFactory;
import org.quickserver.util.pool.QSObjectPool;

public class BasicObjectPool
implements QSObjectPool {
    private static final Logger logger = Logger.getLogger(BasicObjectPool.class.getName());
    private PoolableObjectFactory factory;
    private Config config;
    private final Set activeObjects;
    private final Set idleObjects;
    private volatile boolean inMaintain = false;
    protected AtomicLong activeCount = new AtomicLong();
    private long highestActiveCount;

    public BasicObjectPool() {
        this.activeObjects = Collections.synchronizedSet(new HashSet());
        this.idleObjects = Collections.synchronizedSet(new HashSet());
        this.config = new Config();
    }

    public BasicObjectPool(PoolableObjectFactory factory, Config config) {
        this();
        this.factory = factory;
        if (config != null) {
            this.config = config;
        }
    }

    public void addObject() throws Exception {
        if (this.config.maxIdle == -1 || this.config.maxIdle > this.getNumIdle()) {
            this.idleObjects.add(this.factory.makeObject());
        } else {
            this.maintain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject() throws Exception {
        if (this.getNumIdle() <= 0 && (this.config.maxActive == -1 || this.config.maxActive > this.getNumActive())) {
            this.addObject();
        }
        if (this.getNumIdle() <= 0) {
            throw new NoSuchElementException("No free objects! MaxActive:" + this.config.maxActive + ", NumActive:" + this.getNumActive());
        }
        Object obj = null;
        BasicObjectPool basicObjectPool = this;
        synchronized (basicObjectPool) {
            obj = this.idleObjects.iterator().next();
            this.idleObjects.remove(obj);
            this.factory.activateObject(obj);
            this.activeObjects.add(obj);
        }
        if (this.getHighestActiveCount() < this.activeCount.incrementAndGet()) {
            this.setHighestActiveCount(this.activeCount.get());
        }
        return obj;
    }

    public synchronized void clear() {
        Iterator iterator = this.idleObjects.iterator();
        while (iterator.hasNext()) {
            try {
                this.invalidateObject(iterator.next());
            }
            catch (Exception e) {
                logger.warning("Error in BasicObjectPool.clear : " + e);
            }
        }
        this.idleObjects.clear();
    }

    public void close() throws Exception {
        this.clear();
        this.activeObjects.clear();
    }

    public int getNumActive() {
        return this.activeObjects.size();
    }

    public int getNumIdle() {
        return this.idleObjects.size();
    }

    public void invalidateObject(Object obj) throws Exception {
        this.factory.destroyObject(obj);
    }

    public synchronized void returnObject(Object obj) throws Exception {
        if (this.activeObjects.remove(obj)) {
            this.activeCount.decrementAndGet();
        }
        if (!this.factory.validateObject(obj)) {
            logger.log(Level.FINER, "Object not good for return: {0}", obj);
            return;
        }
        this.factory.passivateObject(obj);
        this.idleObjects.add(obj);
        if (this.config.maxIdle != -1 && this.config.maxIdle < this.getNumIdle()) {
            this.maintain();
        }
    }

    public void setFactory(PoolableObjectFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintain() {
        if (this.inMaintain) {
            return;
        }
        this.inMaintain = true;
        logger.log(Level.FINEST, "Starting maintain: {0}", this.getNumIdle());
        while (this.getNumIdle() > this.config.maxIdle) {
            try {
                Set set = this.idleObjects;
                synchronized (set) {
                    Object obj = this.idleObjects.iterator().next();
                    this.idleObjects.remove(obj);
                    this.invalidateObject(obj);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error in BasicObjectPool.maintain : {0}", e);
            }
        }
        this.inMaintain = false;
        logger.log(Level.FINEST, "Finished maintain: {0}", this.getNumIdle());
    }

    public Iterator getAllActiveObjects() {
        LinkedList _list = new LinkedList();
        _list.addAll(this.activeObjects);
        return _list.iterator();
    }

    public Object getObjectToSynchronize() {
        return this.activeObjects;
    }

    public long getHighestActiveCount() {
        return this.highestActiveCount;
    }

    public void setHighestActiveCount(long highestActiveCount) {
        this.highestActiveCount = highestActiveCount;
    }

    public static class Config {
        public int maxActive = -1;
        public int maxIdle = 10;
    }
}

