/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.logging;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quickserver.net.InitServerHook;
import org.quickserver.net.server.QuickServer;
import org.quickserver.util.logging.SimpleTextFormatter;

public class SimpleJDKLoggingHook
implements InitServerHook {
    private QuickServer quickserver;

    public String info() {
        return "Init Server Hook to setup logging.";
    }

    public void handleInit(QuickServer quickserver) throws Exception {
        Logger logger = null;
        FileHandler txtLog = null;
        File log = new File("./log/");
        if (!log.canRead()) {
            log.mkdir();
        }
        try {
            String level = System.getProperty("org.quickserver.util.logging.SimpleJDKLoggingHook.Level");
            logger = Logger.getLogger("");
            logger.setLevel(Level.FINEST);
            int count = 100;
            String temp = System.getProperty("org.quickserver.util.logging.SimpleJDKLoggingHook.Count");
            if (temp != null) {
                try {
                    count = Integer.parseInt(temp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            txtLog = new FileHandler("log/" + quickserver.getName() + "_%u%g.txt", 0x100000, count, true);
            txtLog.setFormatter(new SimpleTextFormatter());
            SimpleJDKLoggingHook.setLevel(txtLog, level);
            logger.addHandler(txtLog);
            logger = Logger.getLogger("filesrv");
            quickserver.setAppLogger(logger);
        }
        catch (IOException e) {
            System.err.println("Could not create txtLog FileHandler : " + e);
            throw e;
        }
    }

    private static void setLevel(FileHandler target, String temp) {
        if (temp == null) {
            target.setLevel(Level.FINE);
            return;
        }
        if ((temp = temp.toUpperCase()).equals("SEVERE")) {
            target.setLevel(Level.SEVERE);
        } else if (temp.equals("WARNING")) {
            target.setLevel(Level.WARNING);
        } else if (temp.equals("INFO")) {
            target.setLevel(Level.INFO);
        } else if (temp.equals("CONFIG")) {
            target.setLevel(Level.CONFIG);
        } else if (temp.equals("FINE")) {
            target.setLevel(Level.FINE);
        } else if (temp.equals("FINER")) {
            target.setLevel(Level.FINER);
        } else if (temp.equals("FINEST")) {
            target.setLevel(Level.FINEST);
        } else if (temp.equals("OFF")) {
            target.setLevel(Level.OFF);
        }
    }
}

