/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.quickserver.util.MyString;

public class MiniFormatter
extends Formatter {
    private final SimpleDateFormat df = new SimpleDateFormat("MMM d, yyyy HH:mm a");
    private final String lineSeparator = System.getProperty("line.separator");

    public String format(LogRecord record) {
        Date date = new Date();
        date.setTime(record.getMillis());
        StringBuilder sb = new StringBuilder();
        sb.append(this.df.format(date));
        sb.append(" - ");
        sb.append(MyString.alignLeft(record.getLevel().getLocalizedName(), 7));
        sb.append(" : ");
        sb.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            sb.append(this.lineSeparator);
            sb.append("[Exception: ");
            sb.append(record.getThrown().toString());
            sb.append(']');
        }
        sb.append(this.lineSeparator);
        return sb.toString();
    }
}

